/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.FileIncludeContextHectorPanel;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.include.FileIncludeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileIncludeContextHectorProvider
implements HectorComponentPanelsProvider {
    private final FileIncludeManager myIncludeManager;

    public FileIncludeContextHectorProvider(FileIncludeManager includeManager) {
        this.myIncludeManager = includeManager;
    }

    @Nullable
    public HectorComponentPanel createConfigurable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/FileIncludeContextHectorProvider.createConfigurable must not be null");
        }
        if (DumbService.getInstance((Project)file.getProject()).isDumb()) {
            return null;
        }
        if (this.myIncludeManager.getIncludingFiles(file.getVirtualFile(), false).length > 0) {
            return new FileIncludeContextHectorPanel(file, this.myIncludeManager);
        }
        return null;
    }
}

