/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WebEditorOptionsProvider
implements EditorOptionsProvider {
    private JPanel myWholePanel;
    private JCheckBox myAutomaticallyInsertClosingTagCheckBox;
    private JCheckBox myAutomaticallyInsertRequiredAttributesCheckBox;
    private JCheckBox myAutomaticallyStartAttributeAfterCheckBox;
    private JCheckBox myEnableZenCodingCheckBox;
    private JComboBox myZenCodingExpandShortcutCombo;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);

    public WebEditorOptionsProvider() {
        this.$$$setupUI$$$();
        this.myZenCodingExpandShortcutCombo.addItem(SPACE);
        this.myZenCodingExpandShortcutCombo.addItem(TAB);
        this.myZenCodingExpandShortcutCombo.addItem(ENTER);
        this.myEnableZenCodingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebEditorOptionsProvider.this.myZenCodingExpandShortcutCombo.setEnabled(WebEditorOptionsProvider.this.myEnableZenCodingCheckBox.isSelected());
            }
        });
    }

    public String getDisplayName() {
        return XmlBundle.message((String)"web.editor.configuration.title", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.myWholePanel;
    }

    private char getSelectedZenCodingExpandShortcut() {
        Object selectedItem = this.myZenCodingExpandShortcutCombo.getSelectedItem();
        if (TAB.equals(selectedItem)) {
            return '\t';
        }
        if (ENTER.equals(selectedItem)) {
            return '\n';
        }
        return ' ';
    }

    public boolean isModified() {
        WebEditorOptions xmlEditorOptions = WebEditorOptions.getInstance();
        return xmlEditorOptions.isAutomaticallyInsertClosingTag() != this.myAutomaticallyInsertClosingTagCheckBox.isSelected() || xmlEditorOptions.isAutomaticallyInsertRequiredAttributes() != this.myAutomaticallyInsertRequiredAttributesCheckBox.isSelected() || xmlEditorOptions.isAutomaticallyStartAttribute() != this.myAutomaticallyStartAttributeAfterCheckBox.isSelected() || xmlEditorOptions.isZenCodingEnabled() != this.myEnableZenCodingCheckBox.isSelected() || xmlEditorOptions.getZenCodingExpandShortcut() != this.getSelectedZenCodingExpandShortcut();
    }

    public void apply() throws ConfigurationException {
        WebEditorOptions xmlEditorOptions = WebEditorOptions.getInstance();
        xmlEditorOptions.setAutomaticallyInsertClosingTag(this.myAutomaticallyInsertClosingTagCheckBox.isSelected());
        xmlEditorOptions.setAutomaticallyInsertRequiredAttributes(this.myAutomaticallyInsertRequiredAttributesCheckBox.isSelected());
        xmlEditorOptions.setAutomaticallyStartAttribute(this.myAutomaticallyStartAttributeAfterCheckBox.isSelected());
        xmlEditorOptions.setZenCodingEnabled(this.myEnableZenCodingCheckBox.isSelected());
        xmlEditorOptions.setZenCodingExpandShortcut(this.getSelectedZenCodingExpandShortcut());
    }

    public void reset() {
        WebEditorOptions xmlEditorOptions = WebEditorOptions.getInstance();
        this.myAutomaticallyInsertClosingTagCheckBox.setSelected(xmlEditorOptions.isAutomaticallyInsertClosingTag());
        this.myAutomaticallyInsertRequiredAttributesCheckBox.setSelected(xmlEditorOptions.isAutomaticallyInsertRequiredAttributes());
        this.myAutomaticallyStartAttributeAfterCheckBox.setSelected(xmlEditorOptions.isAutomaticallyStartAttribute());
        this.myEnableZenCodingCheckBox.setSelected(xmlEditorOptions.isZenCodingEnabled());
        this.myZenCodingExpandShortcutCombo.setEnabled(xmlEditorOptions.isZenCodingEnabled());
        char shortcut = (char)WebEditorOptions.getInstance().getZenCodingExpandShortcut();
        if (shortcut == '\t') {
            this.myZenCodingExpandShortcutCombo.setSelectedItem(TAB);
        } else if (shortcut == '\n') {
            this.myZenCodingExpandShortcutCombo.setSelectedItem(ENTER);
        } else {
            this.myZenCodingExpandShortcutCombo.setSelectedItem(SPACE);
        }
    }

    public void disposeUIResources() {
    }

    public String getId() {
        return "editor.preferences.webOptions";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/XmlBundle").getString("xml.editor.options.misc.title"), 0, 0, null, null));
        this.myAutomaticallyInsertClosingTagCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Automatically insert closing tag");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myAutomaticallyInsertRequiredAttributesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Automatically insert required attributes");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myAutomaticallyStartAttributeAfterCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Automatically start attribute");
        jCheckBox2.setSelected(false);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myEnableZenCodingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable Zen Coding");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Expand abbreviation with");
        jPanel2.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myZenCodingExpandShortcutCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

