/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ConfigureBranchesAction;
import org.jetbrains.idea.svn.history.MergeInfoUpdatesListener;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnLoadingRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnRepositoryLocationGroup;
import org.jetbrains.idea.svn.history.SvnVersionFilterComponent;
import org.jetbrains.idea.svn.history.TreeStructureNode;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnCommittedChangesProvider
implements CachingCommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> {
    private final Project myProject;
    private final SvnVcs myVcs;
    private final MessageBusConnection myConnection;
    private MergeInfoUpdatesListener myMergeInfoUpdatesListener;
    private final MyZipper myZipper;
    public static final int VERSION_WITH_COPY_PATHS_ADDED = 2;
    public static final int VERSION_WITH_REPLACED_PATHS = 3;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.SvnCommittedChangesProvider");

    public SvnCommittedChangesProvider(Project project) {
        this.myProject = project;
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.myZipper = new MyZipper();
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE, (Object)new VcsConfigurationChangeListener.DetailedNotification(){

            public void execute(final Project project, final VirtualFile vcsRoot, final List<CommittedChangeList> cachedList) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (project.isDisposed()) {
                            return;
                        }
                        for (CommittedChangeList committedChangeList : cachedList) {
                            if (!(committedChangeList instanceof SvnChangeList) || vcsRoot != null && !vcsRoot.equals(((SvnChangeList)committedChangeList).getVcsRoot())) continue;
                            ((SvnChangeList)committedChangeList).forceReloadCachedInfo(true);
                        }
                    }
                });
            }
        });
    }

    public ChangeBrowserSettings createDefaultSettings() {
        return new ChangeBrowserSettings();
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new SvnVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public RepositoryLocation getLocationFor(FilePath root) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        String[] urls = SvnUtil.getLocationsForModule(this.myVcs, root.getIOFile(), progress);
        if (urls.length == 1) {
            return new SvnRepositoryLocation(urls[0]);
        }
        return null;
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        if (repositoryPath == null) {
            return this.getLocationFor(root);
        }
        return new SvnLoadingRepositoryLocation(repositoryPath, this.myVcs);
    }

    public VcsCommittedListsZipper getZipper() {
        return this.myZipper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, final AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            String repositoryRoot;
            final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]));
                progress.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", location));
            }
            SVNRepository repository = null;
            try {
                repository = this.myVcs.createRepository(svnLocation.getURL());
                repositoryRoot = repository.getRepositoryRoot(true).toString();
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
            final ChangeBrowserSettings.Filter filter = settings.createFilter();
            this.getCommittedChangesImpl(settings, svnLocation.getURL(), new String[]{""}, maxCount, new Consumer<SVNLogEntry>(){

                public void consume(SVNLogEntry svnLogEntry) {
                    SvnChangeList cl = new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, svnLogEntry, repositoryRoot);
                    if (filter.accepts((CommittedChangeList)cl)) {
                        consumer.consume((Object)cl);
                    }
                }
            }, false, true);
        }
        finally {
            consumer.finished();
        }
    }

    public List<SvnChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        String repositoryRoot;
        final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        final ArrayList<SvnChangeList> result = new ArrayList<SvnChangeList>();
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]));
            progress.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", location));
        }
        SVNRepository repository = null;
        try {
            repository = this.myVcs.createRepository(svnLocation.getURL());
            repositoryRoot = repository.getRepositoryRoot(true).toString();
            repository.closeSession();
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
        this.getCommittedChangesImpl(settings, svnLocation.getURL(), new String[]{""}, maxCount, new Consumer<SVNLogEntry>(){

            public void consume(SVNLogEntry svnLogEntry) {
                result.add(new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, svnLogEntry, repositoryRoot));
            }
        }, false, true);
        settings.filterChanges(result);
        return result;
    }

    public void getCommittedChangesWithMergedRevisons(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, final PairConsumer<SvnChangeList, TreeStructureNode<SVNLogEntry>> finalConsumer) throws VcsException {
        String repositoryRoot;
        final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]));
            progress.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", location));
        }
        SVNRepository repository = null;
        try {
            repository = this.myVcs.createRepository(svnLocation.getURL());
            repositoryRoot = repository.getRepositoryRoot(true).toString();
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
        final MergeTrackerProxy proxy = new MergeTrackerProxy((Consumer)new Consumer<TreeStructureNode<SVNLogEntry>>(){

            public void consume(TreeStructureNode<SVNLogEntry> node) {
                finalConsumer.consume((Object)new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, node.getMe(), repositoryRoot), node);
            }
        });
        final SvnMergeSourceTracker mergeSourceTracker = new SvnMergeSourceTracker(new ThrowableConsumer<Pair<SVNLogEntry, Integer>, SVNException>(){

            public void consume(Pair<SVNLogEntry, Integer> svnLogEntryIntegerPair) throws SVNException {
                proxy.consume(svnLogEntryIntegerPair);
            }
        });
        this.getCommittedChangesImpl(settings, svnLocation.getURL(), new String[]{""}, maxCount, new Consumer<SVNLogEntry>(){

            public void consume(SVNLogEntry svnLogEntry) {
                try {
                    mergeSourceTracker.consume(svnLogEntry);
                }
                catch (SVNException e) {
                    throw new RuntimeException(e);
                }
            }
        }, true, false);
        proxy.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCommittedChangesImpl(ChangeBrowserSettings settings, String url, String[] filterUrls, int maxCount, final Consumer<SVNLogEntry> resultConsumer, boolean includeMergedRevisions, final boolean filterOutByDate) throws VcsException {
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]));
            progress.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", url));
        }
        try {
            SVNRevision revisionBefore;
            SVNLogClient logger = this.myVcs.createLogClient();
            final String author = settings.getUserFilter();
            Date dateFrom = settings.getDateAfterFilter();
            Long changeFrom = settings.getChangeAfterFilter();
            Date dateTo = settings.getDateBeforeFilter();
            Long changeTo = settings.getChangeBeforeFilter();
            if (dateTo != null) {
                revisionBefore = SVNRevision.create((Date)dateTo);
            } else if (changeTo != null) {
                revisionBefore = SVNRevision.create((long)changeTo);
            } else {
                long revision;
                SVNRepository repository = null;
                try {
                    repository = this.myVcs.createRepository(url);
                    revision = repository.getLatestRevision();
                }
                finally {
                    if (repository != null) {
                        repository.closeSession();
                    }
                }
                revisionBefore = SVNRevision.create((long)revision);
            }
            SVNRevision revisionAfter = dateFrom != null ? SVNRevision.create((Date)dateFrom) : (changeFrom != null ? SVNRevision.create((long)changeFrom) : SVNRevision.create((long)1L));
            logger.doLog(SVNURL.parseURIEncoded((String)url), filterUrls, revisionBefore, revisionBefore, revisionAfter, settings.STOP_ON_COPY, true, includeMergedRevisions, (long)maxCount, null, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) {
                    if (SvnCommittedChangesProvider.this.myProject.isDisposed()) {
                        throw new ProcessCanceledException();
                    }
                    if (progress != null) {
                        progress.setText2(SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
                        progress.checkCanceled();
                    }
                    if (filterOutByDate && logEntry.getDate() == null) {
                        return;
                    }
                    if (author == null || author.equalsIgnoreCase(logEntry.getAuthor())) {
                        resultConsumer.consume((Object)logEntry);
                    }
                }
            });
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn(SvnBundle.message("revision.title", new Object[0])), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
    }

    private void refreshMergeInfo(RootsAndBranches action) {
        if (this.myMergeInfoUpdatesListener == null) {
            this.myMergeInfoUpdatesListener = new MergeInfoUpdatesListener(this.myProject, this.myConnection);
        }
        this.myMergeInfoUpdatesListener.addPanel(action);
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, @Nullable RepositoryLocation location) {
        final RootsAndBranches rootsAndBranches = new RootsAndBranches(this.myProject, manager, location);
        this.refreshMergeInfo(rootsAndBranches);
        DefaultActionGroup popup = new DefaultActionGroup(this.myVcs.getDisplayName(), true);
        popup.add((AnAction)rootsAndBranches.getIntegrateAction());
        popup.add((AnAction)rootsAndBranches.getUndoIntegrateAction());
        popup.add((AnAction)new ConfigureBranchesAction());
        ShowHideMergePanel action = new ShowHideMergePanel(manager, rootsAndBranches.getStrategy());
        return new VcsCommittedViewAuxiliary(Collections.singletonList(popup), new Runnable(){

            @Override
            public void run() {
                if (SvnCommittedChangesProvider.this.myMergeInfoUpdatesListener != null) {
                    SvnCommittedChangesProvider.this.myMergeInfoUpdatesListener.removePanel(rootsAndBranches);
                    rootsAndBranches.dispose();
                }
            }
        }, Collections.singletonList(action));
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    public int getFormatVersion() {
        return 3;
    }

    public void writeChangeList(DataOutput dataStream, SvnChangeList list) throws IOException {
        list.writeToStream(dataStream);
    }

    public SvnChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        int version = this.getFormatVersion();
        return new SvnChangeList(this.myVcs, (SvnRepositoryLocation)location, stream, 2 <= version, 3 <= version);
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) {
        return null;
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return SvnBundle.message("changes.browser.revision.term", new Object[0]);
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, SvnChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    public void deactivate() {
        this.myConnection.disconnect();
    }

    private static class ShowHideMergePanel
    extends ToggleAction {
        private final DecoratorManager myManager;
        private final ChangeListFilteringStrategy myStrategy;
        private boolean myIsSelected;
        private static final String ourKey = "MERGE_PANEL";

        public ShowHideMergePanel(DecoratorManager manager, ChangeListFilteringStrategy strategy) {
            this.myManager = manager;
            this.myStrategy = strategy;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setIcon(IconLoader.getIcon((String)"/icons/ShowIntegratedFrom.png"));
            presentation.setText(SvnBundle.message("committed.changes.action.enable.merge.highlighting", new Object[0]));
            presentation.setDescription(SvnBundle.message("committed.changes.action.enable.merge.highlighting.description.text", new Object[0]));
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myIsSelected;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myIsSelected = state;
            if (state) {
                this.myManager.setFilteringStrategy(ourKey, this.myStrategy);
            } else {
                this.myManager.removeFilteringStrategy(ourKey);
            }
        }
    }

    private static class MergeTrackerProxy
    implements ThrowableConsumer<Pair<SVNLogEntry, Integer>, SVNException> {
        private TreeStructureNode<SVNLogEntry> myCurrentHierarchy;
        private final Consumer<TreeStructureNode<SVNLogEntry>> myConsumer;

        private MergeTrackerProxy(Consumer<TreeStructureNode<SVNLogEntry>> consumer) {
            this.myConsumer = consumer;
        }

        public void consume(Pair<SVNLogEntry, Integer> svnLogEntryIntegerPair) throws SVNException {
            SVNLogEntry logEntry = (SVNLogEntry)svnLogEntryIntegerPair.getFirst();
            Integer mergeLevel = (Integer)svnLogEntryIntegerPair.getSecond();
            if (mergeLevel < 0) {
                if (this.myCurrentHierarchy != null) {
                    this.myConsumer.consume(this.myCurrentHierarchy);
                }
                if (logEntry.hasChildren()) {
                    this.myCurrentHierarchy = new TreeStructureNode<SVNLogEntry>(logEntry);
                } else {
                    this.myCurrentHierarchy = null;
                    this.myConsumer.consume(new TreeStructureNode<SVNLogEntry>(logEntry));
                }
            } else {
                MergeTrackerProxy.addToLevel(this.myCurrentHierarchy, logEntry, mergeLevel);
            }
        }

        public void finish() {
            if (this.myCurrentHierarchy != null) {
                this.myConsumer.consume(this.myCurrentHierarchy);
            }
        }

        private static void addToLevel(TreeStructureNode<SVNLogEntry> tree, SVNLogEntry entry, int left) {
            assert (tree != null);
            if (left == 0) {
                tree.add(entry);
            } else {
                List<TreeStructureNode<SVNLogEntry>> children = tree.getChildren();
                assert (!children.isEmpty());
                MergeTrackerProxy.addToLevel(children.get(children.size() - 1), entry, left - 1);
            }
        }
    }

    private class MyZipper
    implements VcsCommittedListsZipper {
        private MyZipper() {
        }

        public Pair<List<RepositoryLocationGroup>, List<RepositoryLocation>> groupLocations(List<RepositoryLocation> in) {
            ArrayList<SvnRepositoryLocationGroup> groups = new ArrayList<SvnRepositoryLocationGroup>();
            ArrayList<Object> singles = new ArrayList<Object>();
            MultiMap map = new MultiMap();
            for (RepositoryLocation location : in) {
                SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
                String url = svnLocation.getURL();
                SVNURL root = SvnUtil.getRepositoryRoot(SvnCommittedChangesProvider.this.myVcs, url);
                if (root == null) {
                    LOG.info("repository root not found for location:" + location.toPresentableString());
                    singles.add(location);
                    continue;
                }
                map.putValue((Object)root, (Object)svnLocation);
            }
            Set keys = map.keySet();
            for (SVNURL key : keys) {
                Collection repositoryLocations = map.get((Object)key);
                if (repositoryLocations.size() == 1) {
                    singles.add(repositoryLocations.iterator().next());
                    continue;
                }
                SvnRepositoryLocationGroup group = new SvnRepositoryLocationGroup(key, repositoryLocations);
                groups.add(group);
            }
            return new Pair(groups, singles);
        }

        public CommittedChangeList zip(RepositoryLocationGroup group, List<CommittedChangeList> lists) {
            return new SvnChangeList(lists, new SvnRepositoryLocation(group.toPresentableString()));
        }

        public long getNumber(CommittedChangeList list) {
            return list.getNumber();
        }
    }
}

