/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ExternallyRenamedChange;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnChangeList
implements CommittedChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history");
    private final SvnVcs myVcs;
    private final SvnRepositoryLocation myLocation;
    private String myRepositoryRoot;
    private long myRevision;
    private String myAuthor;
    private Date myDate;
    private String myMessage;
    private final Set<String> myChangedPaths;
    private final Set<String> myAddedPaths;
    private final Set<String> myDeletedPaths;
    private final Set<String> myReplacedPaths;
    private ChangesListCreationHelper myListsHolder;
    private SVNURL myBranchUrl;
    private boolean myCachedInfoLoaded;
    private final Map<String, String> myCopiedAddedPaths;
    private RootUrlInfo myWcRoot;
    private final CommonPathSearcher myCommonPathSearcher;

    public SvnChangeList(@NotNull List<CommittedChangeList> lists, @NotNull SvnRepositoryLocation location) {
        if (lists == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/history/SvnChangeList.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/history/SvnChangeList.<init> must not be null");
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new HashMap<String, String>();
        SvnChangeList sample = (SvnChangeList)lists.get(0);
        this.myVcs = sample.myVcs;
        this.myLocation = location;
        this.myRevision = sample.myRevision;
        this.myAuthor = sample.myAuthor;
        this.myDate = sample.myDate;
        this.myMessage = sample.myMessage;
        this.myRepositoryRoot = sample.myRepositoryRoot;
        this.myCommonPathSearcher = new CommonPathSearcher();
        for (CommittedChangeList list : lists) {
            SvnChangeList svnList = (SvnChangeList)list;
            this.myChangedPaths.addAll(svnList.myChangedPaths);
            this.myAddedPaths.addAll(svnList.myAddedPaths);
            this.myDeletedPaths.addAll(svnList.myDeletedPaths);
            this.myReplacedPaths.addAll(svnList.myReplacedPaths);
        }
    }

    public SvnChangeList(SvnVcs vcs, @NotNull SvnRepositoryLocation location, SVNLogEntry logEntry, String repositoryRoot) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/history/SvnChangeList.<init> must not be null");
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new HashMap<String, String>();
        this.myVcs = vcs;
        this.myLocation = location;
        this.myRevision = logEntry.getRevision();
        String author = logEntry.getAuthor();
        this.myAuthor = author == null ? "" : author;
        this.myDate = logEntry.getDate();
        String message = logEntry.getMessage();
        this.myMessage = message == null ? "" : message;
        this.myRepositoryRoot = repositoryRoot.endsWith("/") ? repositoryRoot.substring(0, repositoryRoot.length() - 1) : repositoryRoot;
        this.myCommonPathSearcher = new CommonPathSearcher();
        for (Object o : logEntry.getChangedPaths().values()) {
            SVNLogEntryPath entry = (SVNLogEntryPath)o;
            String path = entry.getPath();
            this.myCommonPathSearcher.next(path);
            if (entry.getType() == 'A') {
                if (entry.getCopyPath() != null) {
                    this.myCopiedAddedPaths.put(path, entry.getCopyPath());
                }
                this.myAddedPaths.add(path);
                continue;
            }
            if (entry.getType() == 'D') {
                this.myDeletedPaths.add(path);
                continue;
            }
            if (entry.getType() == 'R') {
                this.myReplacedPaths.add(path);
            }
            this.myChangedPaths.add(path);
        }
    }

    public SvnChangeList(SvnVcs vcs, @NotNull SvnRepositoryLocation location, DataInput stream, boolean supportsCopyFromInfo, boolean supportsReplaced) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/history/SvnChangeList.<init> must not be null");
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new HashMap<String, String>();
        this.myVcs = vcs;
        this.myLocation = location;
        this.readFromStream(stream, supportsCopyFromInfo, supportsReplaced);
        this.myCommonPathSearcher = new CommonPathSearcher();
        for (String path : this.myAddedPaths) {
            this.myCommonPathSearcher.next(path);
        }
        for (String path : this.myDeletedPaths) {
            this.myCommonPathSearcher.next(path);
        }
        for (String path : this.myChangedPaths) {
            this.myCommonPathSearcher.next(path);
        }
    }

    public Change getByPath(String path) {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getByPath(path);
    }

    public String getCommitterName() {
        return this.myAuthor;
    }

    public Date getCommitDate() {
        return this.myDate;
    }

    public Collection<Change> getChanges() {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getList();
    }

    private void createLists() {
        this.myListsHolder = new ChangesListCreationHelper();
        HashMap<String, ExternallyRenamedChange> copiedAddedChanges = new HashMap<String, ExternallyRenamedChange>();
        for (String path : this.myAddedPaths) {
            Change addedChange;
            if (this.myCopiedAddedPaths.containsKey(path)) {
                if (this.myDeletedPaths.contains(this.myCopiedAddedPaths.get(path))) {
                    addedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(this.myCopiedAddedPaths.get(path), true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), this.myCopiedAddedPaths.get(path));
                    addedChange.getMoveRelativePath(this.myVcs.getProject());
                    ((ExternallyRenamedChange)addedChange).setCopied(false);
                } else {
                    addedChange = new ExternallyRenamedChange(null, (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), this.myCopiedAddedPaths.get(path));
                }
                copiedAddedChanges.put(this.myCopiedAddedPaths.get(path), (ExternallyRenamedChange)addedChange);
            } else {
                addedChange = new Change(null, (ContentRevision)this.myListsHolder.createRevisionLazily(path, false));
            }
            this.myListsHolder.add(path, addedChange);
        }
        for (String path : this.myDeletedPaths) {
            Change deletedChange;
            if (copiedAddedChanges.containsKey(path)) {
                ExternallyRenamedChange addedChange = (ExternallyRenamedChange)copiedAddedChanges.get(path);
                FilePath source = addedChange.getAfterRevision().getFile();
                deletedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createDeletedItemRevision(path, true), null, source.getPresentableUrl());
                ((ExternallyRenamedChange)deletedChange).setCopied(false);
                ((ExternallyRenamedChange)deletedChange).setRenamedOrMovedTarget(source);
            } else {
                deletedChange = new Change((ContentRevision)this.myListsHolder.createDeletedItemRevision(path, true), null);
            }
            this.myListsHolder.add(path, deletedChange);
        }
        for (String path : this.myChangedPaths) {
            boolean moveAndChange = false;
            boolean replaced = this.myReplacedPaths.contains(path);
            for (String addedPath : this.myAddedPaths) {
                String copyFromPath = this.myCopiedAddedPaths.get(addedPath);
                if (copyFromPath == null || !SVNPathUtil.isAncestor((String)addedPath, (String)path)) continue;
                if (addedPath.length() < path.length()) {
                    String relative = SVNPathUtil.getRelativePath((String)addedPath, (String)path);
                    copyFromPath = SVNPathUtil.append((String)copyFromPath, (String)relative);
                }
                ExternallyRenamedChange renamedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(copyFromPath, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), copyFromPath);
                moveAndChange = true;
                renamedChange.getMoveRelativePath(this.myVcs.getProject());
                renamedChange.setIsReplaced(replaced);
                ExternallyRenamedChange addedChange = (ExternallyRenamedChange)copiedAddedChanges.get(this.myCopiedAddedPaths.get(addedPath));
                if (addedChange != null && addedChange.isCopied()) {
                    renamedChange.setCopied(true);
                } else {
                    renamedChange.setCopied(false);
                }
                this.myListsHolder.add(path, (Change)renamedChange);
                break;
            }
            if (moveAndChange) continue;
            ExternallyRenamedChange renamedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(path, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), null);
            renamedChange.setIsReplaced(replaced);
            renamedChange.setCopied(false);
            this.myListsHolder.add(path, (Change)renamedChange);
        }
    }

    @Nullable
    private FilePath getLocalPath(String path, NotNullFunction<File, Boolean> detector) {
        String fullPath = this.myRepositoryRoot + path;
        return SvnRepositoryLocation.getLocalPath(fullPath, detector, this.myVcs);
    }

    private long getRevision(boolean isBeforeRevision) {
        return isBeforeRevision ? this.myRevision - 1L : this.myRevision;
    }

    public SvnRepositoryLocation getLocation() {
        return this.myLocation;
    }

    @NotNull
    public String getName() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/SvnChangeList.getName must not return null");
        }
        return string;
    }

    public String getComment() {
        return this.myMessage;
    }

    public long getNumber() {
        return this.myRevision;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Collection<Change> getChangesWithMovedTrees() {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getDetailedList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnChangeList that = (SvnChangeList)o;
        if (this.myRevision != that.myRevision) {
            return false;
        }
        if (this.myAuthor != null ? !this.myAuthor.equals(that.myAuthor) : that.myAuthor != null) {
            return false;
        }
        if (this.myDate != null ? !this.myDate.equals(that.myDate) : that.myDate != null) {
            return false;
        }
        return !(this.myMessage != null ? !this.myMessage.equals(that.myMessage) : that.myMessage != null);
    }

    public int hashCode() {
        int result = (int)(this.myRevision ^ this.myRevision >>> 32);
        result = 31 * result + (this.myAuthor != null ? this.myAuthor.hashCode() : 0);
        result = 31 * result + (this.myDate != null ? this.myDate.hashCode() : 0);
        result = 31 * result + (this.myMessage != null ? this.myMessage.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myMessage;
    }

    public void writeToStream(DataOutput stream) throws IOException {
        stream.writeUTF(this.myRepositoryRoot);
        stream.writeLong(this.myRevision);
        stream.writeUTF(this.myAuthor);
        stream.writeLong(this.myDate.getTime());
        IOUtil.writeUTFTruncated((DataOutput)stream, (String)this.myMessage);
        SvnChangeList.writeFiles(stream, this.myChangedPaths);
        SvnChangeList.writeFiles(stream, this.myAddedPaths);
        SvnChangeList.writeFiles(stream, this.myDeletedPaths);
        SvnChangeList.writeMap(stream, this.myCopiedAddedPaths);
        SvnChangeList.writeFiles(stream, this.myReplacedPaths);
    }

    private static void writeFiles(DataOutput stream, Set<String> paths) throws IOException {
        stream.writeInt(paths.size());
        for (String s : paths) {
            stream.writeUTF(s);
        }
    }

    private void readFromStream(DataInput stream, boolean supportsCopyFromInfo, boolean supportsReplaced) throws IOException {
        this.myRepositoryRoot = stream.readUTF();
        this.myRevision = stream.readLong();
        this.myAuthor = stream.readUTF();
        this.myDate = new Date(stream.readLong());
        this.myMessage = stream.readUTF();
        SvnChangeList.readFiles(stream, this.myChangedPaths);
        SvnChangeList.readFiles(stream, this.myAddedPaths);
        SvnChangeList.readFiles(stream, this.myDeletedPaths);
        if (supportsCopyFromInfo) {
            SvnChangeList.readMap(stream, this.myCopiedAddedPaths);
        }
        if (supportsReplaced) {
            SvnChangeList.readFiles(stream, this.myReplacedPaths);
        }
    }

    private static void writeMap(DataOutput stream, Map<String, String> map) throws IOException {
        stream.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stream.writeUTF(entry.getKey());
            stream.writeUTF(entry.getValue());
        }
    }

    private static void readMap(DataInput stream, Map<String, String> map) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            map.put(stream.readUTF(), stream.readUTF());
        }
    }

    private static void readFiles(DataInput stream, Set<String> paths) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            paths.add(stream.readUTF());
        }
    }

    public SVNURL getBranchUrl() {
        if (!this.myCachedInfoLoaded) {
            this.updateCachedInfo();
        }
        return this.myBranchUrl;
    }

    @Nullable
    public VirtualFile getVcsRoot() {
        if (!this.myCachedInfoLoaded) {
            this.updateCachedInfo();
        }
        return this.myWcRoot == null ? null : this.myWcRoot.getRoot();
    }

    @Nullable
    public VirtualFile getRoot() {
        if (!this.myCachedInfoLoaded) {
            this.updateCachedInfo();
        }
        return this.myWcRoot == null ? null : this.myWcRoot.getVirtualFile();
    }

    public RootUrlInfo getWcRootInfo() {
        if (!this.myCachedInfoLoaded) {
            this.updateCachedInfo();
        }
        return this.myWcRoot;
    }

    private void updateCachedInfo() {
        this.myCachedInfoLoaded = true;
        String commonPath = this.myCommonPathSearcher.getCommon();
        if (commonPath != null) {
            SvnFileUrlMapping urlMapping = this.myVcs.getSvnFileUrlMapping();
            String absoluteUrl = SVNPathUtil.append((String)this.myRepositoryRoot, (String)commonPath);
            this.myWcRoot = urlMapping.getWcRootForUrl(absoluteUrl);
            if (this.myWcRoot != null) {
                this.myBranchUrl = SvnUtil.getBranchForUrl(this.myVcs, this.myWcRoot.getVirtualFile(), absoluteUrl);
            }
        }
    }

    public void forceReloadCachedInfo(boolean reloadRoot) {
        this.myCachedInfoLoaded = false;
        this.myBranchUrl = null;
        if (reloadRoot) {
            this.myWcRoot = null;
        }
    }

    public Set<String> getChangedPaths() {
        return this.myChangedPaths;
    }

    public Set<String> getAddedPaths() {
        return this.myAddedPaths;
    }

    public Set<String> getDeletedPaths() {
        return this.myDeletedPaths;
    }

    @Nullable
    public String getWcPath() {
        RootUrlInfo rootInfo = this.getWcRootInfo();
        if (rootInfo == null) {
            return null;
        }
        return rootInfo.getIoFile().getAbsolutePath();
    }

    public boolean allPathsUnder(String path) {
        String commonRelative = this.myCommonPathSearcher.getCommon();
        if (commonRelative != null) {
            return SVNPathUtil.isAncestor((String)path, (String)SVNPathUtil.append((String)this.myRepositoryRoot, (String)commonRelative));
        }
        return false;
    }

    private static class CommonPathSearcher {
        private String myCommon;

        private CommonPathSearcher() {
        }

        public void next(String value) {
            if (value == null) {
                return;
            }
            if (this.myCommon == null) {
                this.myCommon = value;
                return;
            }
            if (value.startsWith(this.myCommon)) {
                return;
            }
            this.myCommon = SVNPathUtil.getCommonPathAncestor((String)this.myCommon, (String)value);
        }

        public String getCommon() {
            return this.myCommon;
        }
    }

    private class ChangesListCreationHelper {
        private final List<Change> myList = new ArrayList<Change>();
        private final Map<String, Change> myPathToChangeMapping;
        private List<Change> myDetailedList;
        private final List<Pair<Integer, Boolean>> myWithoutDirStatus = new ArrayList<Pair<Integer, Boolean>>();
        private SVNRepository myRepository;

        private ChangesListCreationHelper() {
            this.myPathToChangeMapping = new HashMap<String, Change>();
        }

        public void add(String path, Change change) {
            this.myList.add(change);
            this.myPathToChangeMapping.put(path, change);
        }

        public Change getByPath(String path) {
            return this.myPathToChangeMapping.get(path);
        }

        private FilePath localDeletedPath(String fullPath) {
            SvnFileUrlMapping urlMapping = SvnChangeList.this.myVcs.getSvnFileUrlMapping();
            String path = urlMapping.getLocalPath(fullPath);
            if (path != null) {
                File file = new File(path);
                return FilePathImpl.createForDeletedFile((File)file, (boolean)file.isDirectory());
            }
            return null;
        }

        public SvnRepositoryContentRevision createDeletedItemRevision(String path, boolean isBeforeRevision) {
            String fullPath = SvnChangeList.this.myRepositoryRoot + path;
            this.myWithoutDirStatus.add((Pair<Integer, Boolean>)new Pair((Object)this.myList.size(), (Object)isBeforeRevision));
            return SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, this.localDeletedPath(fullPath), SvnChangeList.this.getRevision(isBeforeRevision));
        }

        public SvnRepositoryContentRevision createRevisionLazily(String path, final boolean isBeforeRevision) {
            return SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, SvnChangeList.this.getLocalPath(path, (NotNullFunction<File, Boolean>)((NotNullFunction)new NotNullFunction<File, Boolean>(){

                @NotNull
                public Boolean fun(File file) {
                    ChangesListCreationHelper.this.myWithoutDirStatus.add(new Pair((Object)ChangesListCreationHelper.this.myList.size(), (Object)isBeforeRevision));
                    Boolean bl = Boolean.FALSE;
                    if (bl == null) {
                        throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper$1.fun must not return null");
                    }
                    return bl;
                }
            })), SvnChangeList.this.getRevision(isBeforeRevision));
        }

        public List<Change> getList() {
            return this.myList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Change> getDetailedList() {
            if (this.myDetailedList == null) {
                this.myDetailedList = new ArrayList<Change>(this.myList);
                try {
                    this.myRepository = SvnChangeList.this.myVcs.createRepository(SvnChangeList.this.myRepositoryRoot);
                    this.doRemoteDetails();
                    this.uploadDeletedRenamedChildren();
                }
                catch (SVNException e) {
                    LOG.info((Throwable)e);
                }
                finally {
                    if (this.myRepository != null) {
                        this.myRepository.closeSession();
                        this.myRepository = null;
                    }
                }
            }
            return this.myDetailedList;
        }

        private void doRemoteDetails() throws SVNException {
            for (Pair<Integer, Boolean> idxData : this.myWithoutDirStatus) {
                Change sourceChange = this.myDetailedList.get((Integer)idxData.first);
                SvnRepositoryContentRevision revision = (SvnRepositoryContentRevision)((Boolean)idxData.second != false ? sourceChange.getBeforeRevision() : sourceChange.getAfterRevision());
                if (revision == null) continue;
                boolean status = SVNNodeKind.DIR.equals(this.myRepository.checkPath(revision.getPath(), SvnChangeList.this.getRevision((Boolean)idxData.second)));
                Change replacingChange = new Change((ContentRevision)this.createRevision((SvnRepositoryContentRevision)sourceChange.getBeforeRevision(), status), (ContentRevision)this.createRevision((SvnRepositoryContentRevision)sourceChange.getAfterRevision(), status));
                replacingChange.setIsReplaced(sourceChange.isIsReplaced());
                this.myDetailedList.set((Integer)idxData.first, replacingChange);
            }
            this.myWithoutDirStatus.clear();
        }

        @Nullable
        private SvnRepositoryContentRevision createRevision(SvnRepositoryContentRevision previousRevision, boolean isDir) {
            return previousRevision == null ? null : SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, previousRevision.getPath(), (FilePath)new FilePathImpl(previousRevision.getFile().getIOFile(), isDir), ((SvnRevisionNumber)previousRevision.getRevisionNumber()).getRevision().getNumber());
        }

        private void uploadDeletedRenamedChildren() throws SVNException {
            ArrayList<Change> detailsOnly = new ArrayList<Change>();
            HashSet<Pair<Boolean, String>> duplicateControl = new HashSet<Pair<Boolean, String>>();
            for (Change change : this.myDetailedList) {
                if (change.getBeforeRevision() != null) {
                    duplicateControl.add(new Pair((Object)Boolean.TRUE, (Object)((SvnRepositoryContentRevision)change.getBeforeRevision()).getPath()));
                }
                if (change.getAfterRevision() == null) continue;
                duplicateControl.add(new Pair((Object)Boolean.FALSE, (Object)((SvnRepositoryContentRevision)change.getAfterRevision()).getPath()));
            }
            for (Change change : this.myDetailedList) {
                SvnRepositoryContentRevision revision;
                if (change.getAfterRevision() == null && change.getBeforeRevision().getFile().isDirectory()) {
                    revision = (SvnRepositoryContentRevision)change.getBeforeRevision();
                    detailsOnly.addAll(this.getChildrenAsChanges(revision.getPath(), true, duplicateControl));
                    continue;
                }
                if (change.getBeforeRevision() != null || !change.getAfterRevision().getFile().isDirectory()) continue;
                revision = (SvnRepositoryContentRevision)change.getAfterRevision();
                if (!SvnChangeList.this.myCopiedAddedPaths.containsKey(revision.getPath())) continue;
                detailsOnly.addAll(this.getChildrenAsChanges(revision.getPath(), false, duplicateControl));
            }
            this.myDetailedList.addAll(detailsOnly);
        }

        @NotNull
        private Collection<Change> getChildrenAsChanges(final String path, final boolean isBefore, final Set<Pair<Boolean, String>> duplicateControl) throws SVNException {
            final ArrayList<Change> result = new ArrayList<Change>();
            SVNLogClient client = SvnChangeList.this.myVcs.createLogClient();
            long revision = SvnChangeList.this.getRevision(isBefore);
            client.doList(this.myRepository.getLocation().appendPath(path, true), SVNRevision.create((long)revision), SVNRevision.create((long)revision), true, new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    String childPath = path + '/' + dirEntry.getRelativePath();
                    if (!duplicateControl.contains(new Pair((Object)isBefore, (Object)childPath))) {
                        SvnRepositoryContentRevision contentRevision = ChangesListCreationHelper.this.createRevision(childPath, isBefore, SVNNodeKind.DIR.equals(dirEntry.getKind()));
                        result.add(new Change((ContentRevision)(isBefore ? contentRevision : null), (ContentRevision)(isBefore ? null : contentRevision)));
                    }
                }
            });
            ArrayList<Change> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper.getChildrenAsChanges must not return null");
            }
            return arrayList;
        }

        private SvnRepositoryContentRevision createRevision(String path, boolean isBeforeRevision, final boolean isDir) {
            return SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, SvnChangeList.this.getLocalPath(path, (NotNullFunction<File, Boolean>)((NotNullFunction)new NotNullFunction<File, Boolean>(){

                @NotNull
                public Boolean fun(File file) {
                    Boolean bl = isDir;
                    if (bl == null) {
                        throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper$3.fun must not return null");
                    }
                    return bl;
                }
            })), SvnChangeList.this.getRevision(isBeforeRevision));
        }
    }
}

