/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.containers.SoftHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorMessage;

public class SvnRepositoryCache {
    private final Map<String, List<SVNDirEntry>> myMap = new SoftHashMap();
    private final Map<String, SVNErrorMessage> myErrorsMap = new SoftHashMap();

    public static SvnRepositoryCache getInstance() {
        return (SvnRepositoryCache)ServiceManager.getService(SvnRepositoryCache.class);
    }

    private SvnRepositoryCache() {
    }

    @Nullable
    public List<SVNDirEntry> getChildren(String parent) {
        return this.myMap.get(parent);
    }

    @Nullable
    public SVNErrorMessage getError(String parent) {
        return this.myErrorsMap.get(parent);
    }

    public void put(String parent, SVNErrorMessage error) {
        this.myMap.remove(parent);
        this.myErrorsMap.put(parent, error);
    }

    public void put(String parent, List<SVNDirEntry> children) {
        this.myErrorsMap.remove(parent);
        this.myMap.put(parent, children);
    }

    public void remove(String parent) {
        this.myErrorsMap.remove(parent);
        this.myMap.remove(parent);
    }

    public void clear(String repositoryRootUrl) {
        Iterator<Map.Entry<String, List<SVNDirEntry>>> iterator = this.myMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<SVNDirEntry>> entry = iterator.next();
            if (!entry.getKey().startsWith(repositoryRootUrl)) continue;
            iterator.remove();
        }
    }
}

