/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.ByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.FileByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.FolderByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeRootNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class RepositoryTreeNode
implements TreeNode,
Disposable {
    private TreeNode myParentNode;
    private List<TreeNode> myChildren;
    private final RepositoryTreeModel myModel;
    private final SVNURL myURL;
    private final Object myUserObject;
    private final NodeLoadState myLoadState;
    private NodeLoadState myChildrenLoadState;

    public RepositoryTreeNode(RepositoryTreeModel model, TreeNode parentNode, @NotNull SVNURL url, Object userObject, NodeLoadState state) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/RepositoryTreeNode.<init> must not be null");
        }
        this.myParentNode = parentNode;
        this.myURL = url;
        this.myModel = model;
        this.myUserObject = userObject;
        this.myLoadState = state;
        this.myChildrenLoadState = NodeLoadState.EMPTY;
    }

    public RepositoryTreeNode(RepositoryTreeModel model, TreeNode parentNode, @NotNull SVNURL url, Object userObject) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/RepositoryTreeNode.<init> must not be null");
        }
        this(model, parentNode, url, userObject, NodeLoadState.REFRESHED);
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildren());
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getChildren().get(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public boolean isLeaf() {
        return this.myUserObject instanceof SVNDirEntry ? ((SVNDirEntry)this.myUserObject).getKind() == SVNNodeKind.FILE : false;
    }

    @Override
    public TreeNode getParent() {
        return this.myParentNode;
    }

    public void reload(boolean removeCurrentChildren) {
        this.reload(removeCurrentChildren ? this.myModel.getSelectionKeepingExpander() : this.myModel.getLazyLoadingExpander(), removeCurrentChildren);
    }

    @Nullable
    public TreeNode getNextChildByKey(String key, boolean isFolder) {
        ByKeySelectedSearcher searcher = isFolder ? new FolderByKeySelectedSearcher(key, this.myChildren) : new FileByKeySelectedSearcher(key, this.myChildren);
        return searcher.getNextSelectedByKey();
    }

    public String toString() {
        if (this.myParentNode instanceof RepositoryTreeRootNode) {
            return this.myURL.toString();
        }
        return SVNPathUtil.tail((String)this.myURL.getPath());
    }

    public void reload(Expander expander, boolean removeCurrentChildren) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (removeCurrentChildren || this.myChildren == null) {
            this.initChildren();
        }
        this.myModel.getCacheLoader().load(this, expander);
    }

    private void initChildren() {
        this.myChildren = new ArrayList<TreeNode>();
        this.myChildren.add(new DefaultMutableTreeNode("Loading"));
        this.myChildrenLoadState = NodeLoadState.LOADING;
    }

    private List getChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myChildren == null) {
            this.initChildren();
            this.myModel.getCacheLoader().load(this, this.myModel.getLazyLoadingExpander());
        }
        return this.myChildren;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    @Nullable
    public SVNDirEntry getSVNDirEntry() {
        if (this.myUserObject instanceof SVNDirEntry) {
            return (SVNDirEntry)this.myUserObject;
        }
        return null;
    }

    public void dispose() {
    }

    public TreeNode[] getSelfPath() {
        return this.myModel.getPathToRoot(this);
    }

    public boolean isRepositoryRoot() {
        return !(this.myUserObject instanceof SVNDirEntry);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<TreeNode> getAllAlreadyLoadedChildren() {
        List<TreeNode> list;
        if (this.myChildren != null) {
            ArrayList<TreeNode> result = new ArrayList<TreeNode>(this.myChildren.size());
            for (TreeNode child : this.myChildren) {
                result.add(child);
            }
            list = result;
            if (list == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/dialogs/RepositoryTreeNode.getAllAlreadyLoadedChildren must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/dialogs/RepositoryTreeNode.getAllAlreadyLoadedChildren must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<RepositoryTreeNode> getAlreadyLoadedChildren() {
        List<RepositoryTreeNode> list;
        if (this.myChildren != null) {
            ArrayList<RepositoryTreeNode> result = new ArrayList<RepositoryTreeNode>(this.myChildren.size());
            for (TreeNode child : this.myChildren) {
                if (!(child instanceof RepositoryTreeNode)) continue;
                result.add((RepositoryTreeNode)child);
            }
            list = result;
            if (list == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/dialogs/RepositoryTreeNode.getAlreadyLoadedChildren must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/dialogs/RepositoryTreeNode.getAlreadyLoadedChildren must not return null");
    }

    public boolean isDisposed() {
        return this.myModel.isDisposed();
    }

    public void setChildren(List<SVNDirEntry> children, NodeLoadState state) {
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        for (SVNDirEntry entry : children) {
            if (!this.myModel.isShowFiles() && entry.getKind() != SVNNodeKind.DIR) continue;
            nodes.add(new RepositoryTreeNode(this.myModel, this, entry.getURL(), entry, state));
        }
        this.myChildrenLoadState = state;
        this.myChildren.clear();
        this.myChildren.addAll(nodes);
        this.myModel.reload(this);
    }

    public void setParentNode(TreeNode parentNode) {
        this.myParentNode = parentNode;
    }

    public void setAlienChildren(List<TreeNode> children, NodeLoadState oldState) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<TreeNode>();
        } else {
            this.myChildren.clear();
        }
        for (TreeNode child : children) {
            if (child instanceof RepositoryTreeNode) {
                ((RepositoryTreeNode)child).setParentNode(this);
                this.myChildren.add(child);
                this.myChildrenLoadState = oldState;
                continue;
            }
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            this.myChildren.add(new DefaultMutableTreeNode(((DefaultMutableTreeNode)child).getUserObject()));
            this.myChildrenLoadState = oldState;
        }
        this.myModel.reload(this);
    }

    public void setErrorNode(SVNErrorMessage text, NodeLoadState state) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<TreeNode>();
        }
        this.myChildren.clear();
        this.myChildren.add(new DefaultMutableTreeNode(text));
        this.myChildrenLoadState = NodeLoadState.ERROR;
        this.myModel.reload(this);
    }

    public SvnVcs getVcs() {
        return this.myModel.getVCS();
    }

    public boolean isCached() {
        return NodeLoadState.CACHED.equals((Object)this.myLoadState);
    }

    @Nullable
    public RepositoryTreeNode getNodeWithSamePathUnderModelRoot() {
        return this.myModel.findByUrl(this);
    }

    public RepositoryTreeModel getModel() {
        return this.myModel;
    }

    public NodeLoadState getChildrenLoadState() {
        return this.myChildrenLoadState;
    }

    public void doOnSubtree(NotNullFunction<RepositoryTreeNode, Object> function) {
        SubTreeWalker walker = new SubTreeWalker(this, function);
        walker.execute();
    }

    private static class SubTreeWalker {
        private final RepositoryTreeNode myNode;
        private final NotNullFunction<RepositoryTreeNode, Object> myFunction;

        private SubTreeWalker(RepositoryTreeNode node, NotNullFunction<RepositoryTreeNode, Object> function) {
            this.myNode = node;
            this.myFunction = function;
        }

        public void execute() {
            this.executeImpl(this.myNode);
        }

        private void executeImpl(RepositoryTreeNode node) {
            this.myFunction.fun((Object)node);
            for (RepositoryTreeNode child : node.getAlreadyLoadedChildren()) {
                this.myFunction.fun((Object)child);
            }
        }
    }
}

