/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.List;
import org.testng.internal.ClassHelper;
import org.testng.internal.PropertyUtils;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReporterConfig {
    private String m_className;
    private List<Property> m_properties = new ArrayList<Property>();

    public void addProperty(Property property) {
        this.m_properties.add(property);
    }

    public List<Property> getProperties() {
        return this.m_properties;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_className);
        if (!this.m_properties.isEmpty()) {
            sb.append(":");
            for (int i = 0; i < this.m_properties.size(); ++i) {
                Property property = this.m_properties.get(i);
                sb.append(property.getName());
                sb.append("=");
                sb.append(property.getValue());
                if (i >= this.m_properties.size() - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static ReporterConfig deserialize(String inputString) {
        ReporterConfig reporterConfig = null;
        if (!Utils.isStringEmpty(inputString)) {
            reporterConfig = new ReporterConfig();
            int clsNameEndIndex = inputString.indexOf(":");
            if (clsNameEndIndex == -1) {
                reporterConfig.setClassName(inputString);
            } else {
                reporterConfig.setClassName(inputString.substring(0, clsNameEndIndex));
                String propString = inputString.substring(clsNameEndIndex + 1, inputString.length());
                String[] props = propString.split(",");
                if (props != null && props.length > 0) {
                    for (String prop : props) {
                        String[] propNameAndVal = prop.split("=");
                        if (propNameAndVal == null || propNameAndVal.length != 2) continue;
                        Property property = new Property();
                        property.setName(propNameAndVal[0]);
                        property.setValue(propNameAndVal[1]);
                        reporterConfig.addProperty(property);
                    }
                }
            }
        }
        return reporterConfig;
    }

    public Object newReporterInstance() {
        Object result = null;
        Class<?> reporterClass = ClassHelper.forName(this.m_className);
        if (reporterClass != null) {
            result = ClassHelper.newInstance(reporterClass);
            for (Property property : this.m_properties) {
                PropertyUtils.setProperty(result, property.getName(), property.getValue());
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(new StringBuffer().append("\nClass = ").append(this.m_className).toString());
        for (Property prop : this.m_properties) {
            buf.append(new StringBuffer().append("\n\t ").append(prop.getName()).append("=").append(prop.getValue()).toString());
        }
        return buf.toString();
    }

    public static class Property {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

