/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.MoveAction;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.projectView.Form;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormMoveProvider
implements MoveAction.MoveProvider,
RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.projectView.FormMoveProvider");

    public boolean isEnabledOnDataContext(DataContext dataContext) {
        Form[] forms = (Form[])Form.DATA_KEY.getData(dataContext);
        return forms != null && forms.length > 0;
    }

    public RefactoringActionHandler getHandler(DataContext dataContext) {
        return this;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/projectView/FormMoveProvider.invoke must not be null");
        }
        LOG.debug("invoked FormMoveProvider on file");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/projectView/FormMoveProvider.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/projectView/FormMoveProvider.invoke must not be null");
        }
        Form[] forms = (Form[])Form.DATA_KEY.getData(dataContext);
        LOG.assertTrue(forms != null);
        PsiClass[] classesToMove = new PsiClass[forms.length];
        PsiFile[] filesToMove = new PsiFile[forms.length];
        for (int i = 0; i < forms.length; ++i) {
            classesToMove[i] = forms[i].getClassToBind();
            filesToMove[i] = forms[i].getFormFiles()[0];
        }
        PsiElement initialTargetElement = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        MoveClassesOrPackagesImpl.doMove((Project)project, (PsiElement[])classesToMove, (PsiElement)initialTargetElement, (MoveCallback)new FormMoveCallback(filesToMove, classesToMove));
    }

    private static class MoveFormsProcessor
    extends MoveFilesOrDirectoriesProcessor {
        public MoveFormsProcessor(Project project, PsiElement[] elements, PsiDirectory newParent) {
            super(project, elements, newParent, false, false, null, null);
        }

        protected boolean isPreviewUsages(UsageInfo[] usages) {
            return false;
        }
    }

    private static class FormMoveCallback
    implements MoveClassesOrPackagesCallback {
        private final PsiClass[] myClassesToMove;
        private final PsiFile[] myFilesToMove;

        public FormMoveCallback(PsiFile[] filesToMove, PsiClass[] classesToMove) {
            this.myClassesToMove = classesToMove;
            this.myFilesToMove = filesToMove;
        }

        public void refactoringCompleted() {
        }

        public void classesOrPackagesMoved(MoveDestination destination) {
            for (PsiFile file : this.myFilesToMove) {
                PsiDirectory psiDirectory;
                try {
                    psiDirectory = destination.getTargetDirectory(file);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                FormMoveCallback.moveFormFile(file, psiDirectory);
            }
        }

        public void classesMovedToInner(PsiClass targetClass) {
            PsiDirectory target = targetClass.getContainingFile().getContainingDirectory();
            for (PsiFile file : this.myFilesToMove) {
                FormMoveCallback.moveFormFile(file, target);
            }
        }

        private static void moveFormFile(PsiFile file, PsiDirectory psiDirectory) {
            new MoveFormsProcessor(file.getProject(), new PsiElement[]{file}, psiDirectory).run();
        }

        @Nullable
        public String getElementsToMoveName() {
            if (this.myClassesToMove.length == 1) {
                return UIDesignerBundle.message("move.class.and.form.prompt", UsageViewUtil.getLongName((PsiElement)this.myClassesToMove[0]));
            }
            return UIDesignerBundle.message("move.classes.and.forms.prompt", new Object[0]);
        }
    }
}

