/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import java.util.ArrayList;

public class DeleteGroupAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        GroupItem groupToBeRemoved = (GroupItem)e.getData(GroupItem.DATA_KEY);
        if (groupToBeRemoved == null || project == null) {
            return;
        }
        if (!Palette.isRemovable(groupToBeRemoved)) {
            Messages.showInfoMessage((Project)project, (String)UIDesignerBundle.message("error.cannot.remove.default.group", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        Palette palette = Palette.getInstance(project);
        ArrayList<GroupItem> groups = new ArrayList<GroupItem>(palette.getGroups());
        groups.remove(groupToBeRemoved);
        palette.setGroups(groups);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        GroupItem groupItem = (GroupItem)e.getData(GroupItem.DATA_KEY);
        ComponentItem selectedItem = (ComponentItem)e.getData(ComponentItem.DATA_KEY);
        e.getPresentation().setEnabled(project != null && groupItem != null && !groupItem.isReadOnly() && selectedItem == null);
    }
}

