/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormInspectionUtil {
    private FormInspectionUtil() {
    }

    public static boolean isComponentClass(Module module, IComponent component, Class componentClass) {
        PsiClass labelClass;
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PsiClass aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(component.getComponentClassName(), scope);
        return aClass != null && (labelClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(componentClass.getName(), scope)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)labelClass, (boolean)true);
    }

    @Nullable
    public static String getText(@NotNull Module module, IComponent component) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/inspections/FormInspectionUtil.getText must not be null");
        }
        IProperty textProperty = FormInspectionUtil.findProperty(component, "text");
        if (textProperty != null) {
            Object propValue = textProperty.getPropertyValue(component);
            String value = null;
            if (propValue instanceof StringDescriptor) {
                StringDescriptor descriptor = (StringDescriptor)propValue;
                value = component instanceof RadComponent ? StringDescriptorManager.getInstance(module).resolve((RadComponent)component, descriptor) : StringDescriptorManager.getInstance(module).resolve(descriptor, null);
            } else if (propValue instanceof String) {
                value = (String)propValue;
            }
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    @Nullable
    public static IProperty findProperty(IComponent component, String name) {
        IProperty[] props;
        for (IProperty prop : props = component.getModifiedProperties()) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }
}

