/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.IObjectFactory;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.internal.version.VersionInfo;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSuite
implements Serializable,
Cloneable {
    @Deprecated
    public static final String JAVADOC = "javadoc";
    public static final String JDK5_ANNOTATION_TYPE = AnnotationTypeEnum.JDK.getName();
    public static final String JAVADOC_ANNOTATION_TYPE = AnnotationTypeEnum.JAVADOC.getName();
    public static final String PARALLEL_TESTS = "tests";
    public static final String PARALLEL_METHODS = "methods";
    public static final String PARALLEL_CLASSES = "classes";
    public static final String PARALLEL_NONE = "none";
    private String m_test;
    private static final String DEFAULT_SUITE_NAME = "";
    private String m_name = "";
    private Integer m_verbose = null;
    private String m_parallel = null;
    private Boolean m_isJUnit = Boolean.FALSE;
    private Boolean m_skipFailedInvocationCounts = Boolean.FALSE;
    private int m_threadCount = 5;
    public static final int DEFAULT_DATA_PROVIDER_THREAD_COUNT = 10;
    private int m_dataProviderThreadCount = 10;
    private AnnotationTypeEnum m_annotations;
    private AnnotationTypeEnum m_defaultAnnotations = VersionInfo.getDefaultAnnotationType();
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_expression = null;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlTest> m_tests = Lists.newArrayList();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private String m_fileName;
    private String m_timeOut;
    private List<String> m_suiteFiles = Lists.newArrayList();
    private IObjectFactory m_objectFactory;
    private List<String> m_listeners = Lists.newArrayList();
    private static final long serialVersionUID = 4999962288272750226L;

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getParallel() {
        return this.m_parallel;
    }

    public IObjectFactory getObjectFactory() {
        return this.m_objectFactory;
    }

    public void setObjectFactory(IObjectFactory objectFactory) {
        this.m_objectFactory = objectFactory;
    }

    public void setParallel(String parallel) {
        this.m_parallel = parallel;
    }

    public Integer getVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(Integer verbose) {
        this.m_verbose = verbose;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getTest() {
        return this.m_test;
    }

    public List<XmlTest> getTests() {
        return this.m_tests;
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = methodSelectors;
    }

    public void setBeanShellExpression(String expression) {
        this.m_expression = expression;
    }

    @Deprecated
    public String getExpression() {
        return this.m_expression;
    }

    public String getBeanShellExpression() {
        return this.m_expression;
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (XmlTest test : this.getTests()) {
            Map<String, String> tp = test.getParameters();
            for (Map.Entry<String, String> entry : tp.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public int getThreadCount() {
        return this.m_threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public String getAnnotations() {
        return (this.m_annotations != null ? this.m_annotations : this.m_defaultAnnotations).toString();
    }

    public void setDefaultAnnotations(String annotationType) {
        this.m_defaultAnnotations = AnnotationTypeEnum.valueOf(annotationType);
    }

    public void setAnnotations(String annotations) {
        this.m_annotations = AnnotationTypeEnum.valueOf(annotations);
    }

    public Boolean isJUnit() {
        return this.m_isJUnit;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public Boolean skipFailedInvocationCounts() {
        return this.m_skipFailedInvocationCounts;
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = packages;
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public String toXml() {
        String parallel;
        XMLStringBuffer xsb = new XMLStringBuffer(DEFAULT_SUITE_NAME);
        xsb.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        if (this.getVerbose() != null) {
            p.setProperty("verbose", this.getVerbose().toString());
        }
        if (null != (parallel = this.getParallel()) && !DEFAULT_SUITE_NAME.equals(parallel)) {
            p.setProperty("parallel", parallel);
        }
        p.setProperty("thread-count", String.valueOf(this.getThreadCount()));
        p.setProperty("data-provider-thread-count", String.valueOf(this.getDataProviderThreadCount()));
        p.setProperty("annotations", this.getAnnotations());
        p.setProperty("junit", this.m_isJUnit != null ? this.m_isJUnit.toString() : "false");
        p.setProperty("skipfailedinvocationCounts", this.m_skipFailedInvocationCounts != null ? this.m_skipFailedInvocationCounts.toString() : "false");
        if (null != this.m_objectFactory) {
            p.setProperty("object-factory", this.m_objectFactory.getClass().getName());
        }
        xsb.push("suite", p);
        for (String paramName : this.m_parameters.keySet()) {
            Properties paramProps = new Properties();
            paramProps.setProperty("name", paramName);
            paramProps.setProperty("value", this.m_parameters.get(paramName));
            xsb.addEmptyElement("parameter", paramProps);
        }
        if (null != this.m_listeners && !this.m_listeners.isEmpty()) {
            xsb.push("listeners");
            for (String listenerName : this.m_listeners) {
                Properties listenerProps = new Properties();
                listenerProps.setProperty("class-name", listenerName);
                xsb.addEmptyElement("listener", listenerProps);
            }
            xsb.pop("listeners");
        }
        for (XmlTest test : this.getTests()) {
            xsb.getStringBuffer().append(test.toXml("  "));
        }
        if (null != this.getXmlPackages() && !this.getXmlPackages().isEmpty()) {
            xsb.push("packages");
            for (XmlPackage pack : this.getXmlPackages()) {
                xsb.getStringBuffer().append(pack.toXml("  "));
            }
            xsb.pop("packages");
        }
        if (null != this.getMethodSelectors() && !this.getMethodSelectors().isEmpty()) {
            xsb.push("method-selectors");
            for (XmlMethodSelector selector : this.getMethodSelectors()) {
                xsb.getStringBuffer().append(selector.toXml("  "));
            }
            xsb.pop("method-selectors");
        }
        xsb.pop("suite");
        return xsb.toXML();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Suite: \"").append(this.m_name).append("\" ");
        for (XmlTest t : this.m_tests) {
            result.append("  ").append(t.toString()).append(' ');
        }
        result.append(']');
        return result.toString();
    }

    private static void ppp(String s) {
        System.out.println("[XmlSuite] " + s);
    }

    public Object clone() {
        XmlSuite result = new XmlSuite();
        result.setName(this.getName());
        result.setListeners(this.getListeners());
        result.setAnnotations(this.getAnnotations());
        result.setParallel(this.getParallel());
        result.setThreadCount(this.getThreadCount());
        result.setDataProviderThreadCount(this.getDataProviderThreadCount());
        result.setParameters(this.getAllParameters());
        result.setVerbose(this.getVerbose());
        result.setXmlPackages(this.getXmlPackages());
        result.setBeanShellExpression(this.getExpression());
        result.setMethodSelectors(this.getMethodSelectors());
        result.setJUnit(this.isJUnit());
        result.setSkipFailedInvocationCounts(this.skipFailedInvocationCounts());
        result.setObjectFactory(this.getObjectFactory());
        return result;
    }

    public void setTimeOut(String timeOut) {
        this.m_timeOut = timeOut;
    }

    public String getTimeOut() {
        return this.m_timeOut;
    }

    public long getTimeOut(long def) {
        long result = def;
        if (this.m_timeOut != null) {
            result = new Long(this.m_timeOut);
        }
        return result;
    }

    public void setSuiteFiles(List<String> files) {
        this.m_suiteFiles = files;
    }

    public List<String> getSuiteFiles() {
        return this.m_suiteFiles;
    }

    public void setListeners(List<String> listeners) {
        this.m_listeners = listeners;
    }

    public List<String> getListeners() {
        return this.m_listeners;
    }

    public void setDataProviderThreadCount(int count) {
        this.m_dataProviderThreadCount = count;
    }

    public int getDataProviderThreadCount() {
        return this.m_dataProviderThreadCount;
    }
}

