/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVersion;
import org.jetbrains.annotations.NotNull;

public class GitStashUtils {
    private static final GitVersion QUIET_STASH_SUPPORTED = new GitVersion(1, 6, 4, 0);

    private GitStashUtils() {
    }

    public static boolean saveStash(@NotNull Project project, @NotNull VirtualFile root, String message) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/update/GitStashUtils.saveStash must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/update/GitStashUtils.saveStash must not be null");
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.STASH);
        handler.setNoSSH(true);
        handler.addParameters("save", message);
        String output = handler.run();
        return !output.startsWith("No local changes to save");
    }

    public static void popLastStash(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/update/GitStashUtils.popLastStash must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/update/GitStashUtils.popLastStash must not be null");
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.STASH);
        handler.setNoSSH(true);
        handler.addParameters("pop");
        if (QUIET_STASH_SUPPORTED.isLessOrEqual(GitVcs.getInstance(project).version())) {
            handler.addParameters("--quiet");
        }
        handler.run();
    }
}

