/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.checkout.GitCheckoutDialog;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitCheckout
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("checkout.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/GitCheckout.getActionName must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitCheckout.perform must not be null");
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitCheckout.perform must not be null");
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitCheckout.perform must not be null");
        }
        GitCheckoutDialog dialog = new GitCheckoutDialog(project, gitRoots, defaultRoot);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        GitSimpleHandler branch = dialog.createBranchHandler();
        if (branch != null) {
            branch.run();
        }
        GitLineHandler checkout = dialog.checkoutHandler();
        affectedRoots.add(dialog.gitRoot());
        try {
            GitHandlerUtil.doSynchronously(checkout, GitBundle.message("checking.out", dialog.getSourceBranch()), "git checkout");
        }
        finally {
            exceptions.addAll(checkout.errors());
        }
    }
}

