/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.UndoHelper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerspectiveFileEditor
extends UserDataHolderBase
implements DocumentsEditor,
Committable {
    private final Wrapper myWrapprer = new Wrapper();
    private boolean myInitialised = false;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private final Project myProject;
    private final VirtualFile myFile;
    private final UndoHelper myUndoHelper;
    private boolean myInvalidated;
    private static final FileEditorState FILE_EDITOR_STATE = new FileEditorState(){

        @Override
        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return true;
        }
    };

    protected PerspectiveFileEditor(Project project, VirtualFile file) {
        Document document;
        this.myProject = project;
        this.myUndoHelper = new UndoHelper(project, this);
        this.myFile = file;
        FileEditorManager.getInstance(this.myProject).addFileEditorManagerListener(new FileEditorManagerAdapter(){

            @Override
            public void selectionChanged(FileEditorManagerEvent event) {
                if (!PerspectiveFileEditor.this.isValid()) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PerspectiveFileEditor.this.myUndoHelper.isShowing() && !PerspectiveFileEditor.this.getComponent().isShowing()) {
                            PerspectiveFileEditor.this.deselectNotify();
                        } else if (!PerspectiveFileEditor.this.myUndoHelper.isShowing() && PerspectiveFileEditor.this.getComponent().isShowing()) {
                            PerspectiveFileEditor.this.selectNotify();
                        }
                    }
                });
                FileEditor oldEditor = event.getOldEditor();
                FileEditor newEditor = event.getNewEditor();
                if (oldEditor == null || newEditor == null) {
                    return;
                }
                if (oldEditor.getComponent().isShowing() && newEditor.getComponent().isShowing()) {
                    return;
                }
                if (PerspectiveFileEditor.this.equals(oldEditor)) {
                    if (newEditor instanceof TextEditor) {
                        PerspectiveFileEditor.this.ensureInitialized();
                        PerspectiveFileEditor.this.setSelectionInTextEditor((TextEditor)newEditor, PerspectiveFileEditor.this.getSelectedDomElement());
                    }
                } else if (PerspectiveFileEditor.this.equals(newEditor)) {
                    if (oldEditor instanceof TextEditor) {
                        DomElement element = PerspectiveFileEditor.this.getSelectedDomElementFromTextEditor((TextEditor)oldEditor);
                        if (element != null) {
                            PerspectiveFileEditor.this.ensureInitialized();
                            PerspectiveFileEditor.this.setSelectedDomElement(element);
                        }
                    } else if (oldEditor instanceof PerspectiveFileEditor) {
                        PerspectiveFileEditor.this.ensureInitialized();
                        PerspectiveFileEditor.this.setSelectedDomElement(((PerspectiveFileEditor)oldEditor).getSelectedDomElement());
                    }
                }
            }
        }, this);
        this.myUndoHelper.startListeningDocuments();
        PsiFile psiFile = this.getPsiFile();
        if (psiFile != null && (document = PsiDocumentManager.getInstance(this.getProject()).getDocument(psiFile)) != null) {
            this.addWatchedDocument(document);
        }
    }

    @Nullable
    protected abstract DomElement getSelectedDomElement();

    protected abstract void setSelectedDomElement(DomElement var1);

    public final void addWatchedElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/PerspectiveFileEditor.addWatchedElement must not be null");
        }
        this.addWatchedDocument(this.getDocumentManager().getDocument(DomUtil.getFile(domElement)));
    }

    public final void removeWatchedElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/PerspectiveFileEditor.removeWatchedElement must not be null");
        }
        this.removeWatchedDocument(this.getDocumentManager().getDocument(DomUtil.getFile(domElement)));
    }

    public final void addWatchedDocument(Document document) {
        this.myUndoHelper.addWatchedDocument(document);
    }

    public final void removeWatchedDocument(Document document) {
        this.myUndoHelper.removeWatchedDocument(document);
    }

    @Nullable
    protected DomElement getSelectedDomElementFromTextEditor(TextEditor textEditor) {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiElement psiElement = psiFile.findElementAt(textEditor.getEditor().getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        XmlTag xmlTag = PsiTreeUtil.getParentOfType(psiElement, XmlTag.class);
        return DomManager.getDomManager(this.myProject).getDomElement(xmlTag);
    }

    public void setSelectionInTextEditor(TextEditor textEditor, DomElement element) {
        if (element != null && element.isValid()) {
            XmlTag tag = element.getXmlTag();
            if (tag == null) {
                return;
            }
            PsiFile file = tag.getContainingFile();
            if (file == null) {
                return;
            }
            Document document = this.getDocumentManager().getDocument(file);
            if (document == null || !document.equals(textEditor.getEditor().getDocument())) {
                return;
            }
            textEditor.getEditor().getCaretModel().moveToOffset(tag.getTextOffset());
            textEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    protected final PsiDocumentManager getDocumentManager() {
        return PsiDocumentManager.getInstance(this.myProject);
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return PsiManager.getInstance(this.myProject).findFile(this.myFile);
    }

    @Override
    public final Document[] getDocuments() {
        return this.myUndoHelper.getDocuments();
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public void dispose() {
        if (this.myInvalidated) {
            return;
        }
        this.myInvalidated = true;
        this.myUndoHelper.stopListeningDocuments();
    }

    @Override
    public final boolean isModified() {
        return FileDocumentManager.getInstance().isFileModified(this.getVirtualFile());
    }

    @Override
    public boolean isValid() {
        return this.getVirtualFile().isValid();
    }

    @Override
    public void selectNotify() {
        if (!this.checkIsValid() || this.myInvalidated) {
            return;
        }
        this.ensureInitialized();
        this.setShowing(true);
        this.reset();
    }

    protected final void setShowing(boolean b) {
        this.myUndoHelper.setShowing(b);
    }

    protected final synchronized void ensureInitialized() {
        if (!this.isInitialised()) {
            this.myWrapprer.setContent(this.createCustomComponent());
            this.myInitialised = true;
        }
    }

    @Override
    public void deselectNotify() {
        if (!this.checkIsValid() || this.myInvalidated) {
            return;
        }
        this.setShowing(false);
        this.commit();
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Override
    public FileEditorLocation getCurrentLocation() {
        return new FileEditorLocation(){

            @Override
            public FileEditor getEditor() {
                return PerspectiveFileEditor.this;
            }

            @Override
            public int compareTo(FileEditorLocation fileEditorLocation) {
                return 0;
            }
        };
    }

    @Override
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @Override
    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/PerspectiveFileEditor.getState must not be null");
        }
        FileEditorState fileEditorState = FILE_EDITOR_STATE;
        if (fileEditorState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/PerspectiveFileEditor.getState must not return null");
        }
        return fileEditorState;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/PerspectiveFileEditor.setState must not be null");
        }
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/PerspectiveFileEditor.addPropertyChangeListener must not be null");
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/PerspectiveFileEditor.removePropertyChangeListener must not be null");
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected boolean checkIsValid() {
        if (!this.myInvalidated && !this.isValid()) {
            this.myInvalidated = true;
            this.myPropertyChangeSupport.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
        return !this.myInvalidated;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        Wrapper wrapper = this.getWrapper();
        if (wrapper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/PerspectiveFileEditor.getComponent must not return null");
        }
        return wrapper;
    }

    @NotNull
    protected abstract JComponent createCustomComponent();

    public Wrapper getWrapper() {
        return this.myWrapprer;
    }

    protected final synchronized boolean isInitialised() {
        return this.myInitialised;
    }
}

