/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.actions.generate.DefaultGenerateElementProvider;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomGenerateProvider<T extends DomElement>
extends DefaultGenerateElementProvider<T> {
    @Nullable
    private final String myMappingId;

    public AbstractDomGenerateProvider(String description, Class<T> aClass) {
        this(description, aClass, null);
    }

    public AbstractDomGenerateProvider(String description, Class<T> aClass, String mappingId) {
        super(description, aClass);
        this.myMappingId = mappingId;
    }

    @Override
    public T generate(Project project, Editor editor, PsiFile file) {
        Object t = super.generate(project, editor, file);
        this.runTemplate(editor, file, t);
        return t;
    }

    protected void runTemplate(Editor editor, PsiFile file, T t) {
        DomTemplateRunner.getInstance(file.getProject()).runTemplate(t, this.myMappingId, editor);
    }

    @Override
    protected abstract DomElement getParentDomElement(Project var1, Editor var2, PsiFile var3);

    @Override
    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement copy) {
        DomElement element = this.getElementToNavigate(copy);
        if (element != null) {
            super.doNavigate(navigateProvider, element);
        }
    }

    @Nullable
    protected DomElement getElementToNavigate(T t) {
        return t;
    }

    protected static String getDescription(Class<? extends DomElement> aClass) {
        return StringUtil.join(Arrays.asList(NameUtil.nameToWords((String)aClass.getSimpleName())), (String)" ");
    }
}

