/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;

public class VisibilityUtil {
    @NonNls
    public static final String ESCALATE_VISIBILITY = "EscalateVisible";
    private static final String[] visibilityModifiers = new String[]{"private", "packageLocal", "protected", "public"};

    private VisibilityUtil() {
    }

    public static int compare(@Modifier String v1, @Modifier String v2) {
        return ArrayUtil.find((Object[])visibilityModifiers, (Object)v2) - ArrayUtil.find((Object[])visibilityModifiers, (Object)v1);
    }

    @Modifier
    public static String getHighestVisibility(@Modifier String v1, @Modifier String v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        if ("private".equals(v1)) {
            return v2;
        }
        if ("public".equals(v1)) {
            return "public";
        }
        if ("private".equals(v2)) {
            return v1;
        }
        return "public";
    }

    public static void escalateVisibility(PsiMember modifierListOwner, PsiElement place) throws IncorrectOperationException {
        String modifier;
        int index;
        String visibilityModifier = VisibilityUtil.getVisibilityModifier(modifierListOwner.getModifierList());
        for (index = 0; index < visibilityModifiers.length && !(modifier = visibilityModifiers[index]).equals(visibilityModifier); ++index) {
        }
        while (index < visibilityModifiers.length && !PsiUtil.isAccessible(modifierListOwner, place, null)) {
            modifier = visibilityModifiers[index];
            PsiUtil.setModifierProperty(modifierListOwner, modifier, true);
            ++index;
        }
    }

    @Modifier
    public static String getPossibleVisibility(PsiMember psiMethod, PsiElement place) {
        if (PsiUtil.isAccessible(psiMethod, place, null)) {
            return VisibilityUtil.getVisibilityModifier(psiMethod.getModifierList());
        }
        if (JavaPsiFacade.getInstance(psiMethod.getProject()).arePackagesTheSame(psiMethod, place)) {
            return "packageLocal";
        }
        if (InheritanceUtil.isInheritorOrSelf(PsiTreeUtil.getParentOfType(place, PsiClass.class), psiMethod.getContainingClass(), true)) {
            return "protected";
        }
        return "public";
    }

    @Modifier
    public static String getVisibilityModifier(PsiModifierList list) {
        if (list == null) {
            return "packageLocal";
        }
        for (String modifier : visibilityModifiers) {
            if (!list.hasModifierProperty(modifier)) continue;
            return modifier;
        }
        return "packageLocal";
    }

    public static String getVisibilityString(@Modifier String visibilityModifier) {
        if ("packageLocal".equals(visibilityModifier)) {
            return "";
        }
        return visibilityModifier;
    }

    @Nls
    public static String getVisibilityStringToDisplay(PsiMember member) {
        if (member.hasModifierProperty("public")) {
            return VisibilityUtil.toPresentableText("public");
        }
        if (member.hasModifierProperty("protected")) {
            return VisibilityUtil.toPresentableText("protected");
        }
        if (member.hasModifierProperty("private")) {
            return VisibilityUtil.toPresentableText("private");
        }
        return VisibilityUtil.toPresentableText("packageLocal");
    }

    public static String toPresentableText(@Modifier String modifier) {
        return PsiBundle.visibilityPresentation(modifier);
    }

    public static void fixVisibility(UsageInfo[] usageInfos, PsiMember member, String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (UsageInfo info : usageInfos) {
                PsiElement element = info.getElement();
                if (element == null) continue;
                VisibilityUtil.escalateVisibility(member, element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }

    public static void setVisibility(PsiModifierList modifierList, @Modifier String newVisibility) throws IncorrectOperationException {
        modifierList.setModifierProperty("private", false);
        modifierList.setModifierProperty("public", false);
        modifierList.setModifierProperty("protected", false);
        modifierList.setModifierProperty(newVisibility, true);
    }

    public static void fixVisibility(PsiExpression[] expressions, PsiMember member, String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (PsiExpression element : expressions) {
                VisibilityUtil.escalateVisibility(member, element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }
}

