/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;

public class TableLayout
extends TabLayout {
    private final JBTabsImpl myTabs;
    public TablePassInfo myLastTableLayout;

    public TableLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
    }

    private TablePassInfo computeLayoutTable() {
        TablePassInfo data = new TablePassInfo(this.myTabs);
        Insets insets = this.myTabs.getLayoutInsets();
        data.toFitRec = new Rectangle(insets.left, insets.top, this.myTabs.getWidth() - insets.left - insets.right, this.myTabs.getHeight() - insets.top - insets.bottom);
        int eachRow = 0;
        int eachX = data.toFitRec.x;
        TableRow eachTableRow = new TableRow(data);
        data.table.add(eachTableRow);
        data.requiredRows = 1;
        for (TabInfo eachInfo : this.myTabs.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if ((double)(eachX + size.width) >= data.toFitRec.getMaxX()) {
                ++data.requiredRows;
                eachX = data.toFitRec.x;
            }
            JBTabsImpl.layout(eachLabel, eachX, 0, size.width, 1);
            eachX += size.width;
            data.requiredWidth += size.width;
        }
        int selectedRow = -1;
        eachX = data.toFitRec.x;
        data.rowToFitMaxX = (int)data.toFitRec.getMaxX();
        if (data.requiredRows > 1) {
            int rowFit = insets.left + data.requiredWidth / data.requiredRows;
            for (TabInfo eachInfo : this.myTabs.myVisibleInfos) {
                TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
                Rectangle eachBounds = eachLabel.getBounds();
                if (!eachBounds.contains(rowFit, 0)) continue;
                data.rowToFitMaxX = (int)eachLabel.getBounds().getMaxX();
                break;
            }
        }
        for (TabInfo eachInfo : this.myTabs.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if (eachX + size.width <= data.rowToFitMaxX) {
                eachTableRow.add(eachInfo);
                if (this.myTabs.getSelectedInfo() == eachInfo) {
                    selectedRow = eachRow;
                }
                eachX += size.width;
                continue;
            }
            eachTableRow = new TableRow(data);
            data.table.add(eachTableRow);
            ++eachRow;
            eachX = insets.left + size.width;
            eachTableRow.add(eachInfo);
            if (this.myTabs.getSelectedInfo() != eachInfo) continue;
            selectedRow = eachRow;
        }
        ArrayList<TableRow> toMove = new ArrayList<TableRow>();
        for (int i = selectedRow + 1; i < data.table.size(); ++i) {
            toMove.add(data.table.get(i));
        }
        for (TableRow eachMove : toMove) {
            data.table.remove(eachMove);
            data.table.add(0, eachMove);
        }
        return data;
    }

    public LayoutPassInfo layoutTable() {
        this.myTabs.resetLayout(true);
        TablePassInfo data = this.computeLayoutTable();
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        for (TableRow eachRow : data.table) {
            int eachX = insets.left;
            int deltaToFit = 0;
            boolean toAjust = false;
            if (eachRow.width < data.toFitRec.width && data.table.size() > 1) {
                deltaToFit = (int)Math.floor((double)(data.toFitRec.width - eachRow.width) / (double)eachRow.myColumns.size());
                toAjust = true;
            }
            for (int i = 0; i < eachRow.myColumns.size(); ++i) {
                TabInfo tabInfo = eachRow.myColumns.get(i);
                TabLabel label = this.myTabs.myInfo2Label.get(tabInfo);
                int width = i < eachRow.myColumns.size() - 1 || !toAjust ? label.getPreferredSize().width + deltaToFit : data.toFitRec.width + insets.left - eachX - 1;
                JBTabsImpl.layout(label, eachX, eachY, width, this.myTabs.myHeaderFitSize.height);
                label.setAligmentToCenter(deltaToFit > 0);
                eachX += width;
            }
            eachY += this.myTabs.myHeaderFitSize.height - 1;
        }
        if (this.myTabs.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myTabs.myInfo2Toolbar.get(this.myTabs.getSelectedInfo());
            int xAddin = 0;
            if (!this.myTabs.myHorizontalSide && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                xAddin = selectedToolbar.getPreferredSize().width + 1;
                JBTabsImpl.layout(selectedToolbar, insets.left + 1, eachY + 1, selectedToolbar.getPreferredSize().width, this.myTabs.getHeight() - eachY - insets.bottom - 2);
            }
            this.myTabs.layoutComp(xAddin, eachY + 2 - this.myTabs.getLayoutInsets().top, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
        }
        this.myLastTableLayout = data;
        return data;
    }
}

