/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.InstanceofCheckerGenerator;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectPattern<T, Self extends ObjectPattern<T, Self>>
implements Cloneable,
ElementPattern<T> {
    private ElementPatternCondition<T> myCondition;

    protected ObjectPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern.<init> must not be null");
        }
        this.myCondition = new ElementPatternCondition<T>(condition);
    }

    protected ObjectPattern(Class<T> aClass) {
        final Condition<Object> checker = InstanceofCheckerGenerator.getInstance().getInstanceofChecker(aClass);
        this.myCondition = new ElementPatternCondition(new InitialPatternCondition<T>(aClass){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return checker.value(o);
            }
        });
    }

    @Override
    public final boolean accepts(@Nullable Object t) {
        return this.myCondition.accepts(t, new ProcessingContext());
    }

    @Override
    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        return this.myCondition.accepts(o, context);
    }

    @Override
    public final ElementPatternCondition getCondition() {
        return this.myCondition;
    }

    public Self andNot(ElementPattern pattern) {
        return this.and(StandardPatterns.not(pattern));
    }

    public Self andOr(ElementPattern ... patterns) {
        return this.and(StandardPatterns.or(patterns));
    }

    public Self and(final ElementPattern pattern) {
        return this.with(new PatternCondition<T>("and"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern$2.accepts must not be null");
                }
                return pattern.getCondition().accepts(t, context);
            }
        });
    }

    public Self equalTo(final @NotNull T o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern.equalTo must not be null");
        }
        return this.with(new ValuePatternCondition<T>("equalTo", Collections.singleton(o)){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern$3.accepts must not be null");
                }
                return t.equals(o);
            }
        });
    }

    @NotNull
    public Self oneOf(T ... values) {
        Self Self = this.oneOf((Collection<T>)new THashSet(Arrays.asList(values)));
        if (Self == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/ObjectPattern.oneOf must not return null");
        }
        return Self;
    }

    @NotNull
    public Self oneOf(Collection<T> set) {
        Self Self = this.with(new ValuePatternCondition<T>("oneOf", set));
        if (Self == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/ObjectPattern.oneOf must not return null");
        }
        return Self;
    }

    public Self isNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o == null;
            }
        }));
    }

    public Self notNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o != null;
            }
        }));
    }

    public Self save(final Key<? super T> key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern$6.accepts must not be null");
                }
                context.put(key, t);
                return true;
            }
        });
    }

    public Self save(final @NonNls String key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern$7.accepts must not be null");
                }
                context.put(key, t);
                return true;
            }
        });
    }

    public Self with(PatternCondition<? super T> pattern) {
        ElementPatternCondition<? super T> condition = this.myCondition.append(pattern);
        return this.adapt(condition);
    }

    private Self adapt(ElementPatternCondition<T> condition) {
        try {
            ObjectPattern s = (ObjectPattern)this.clone();
            s.myCondition = condition;
            return (Self)s;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Self without(final PatternCondition<? super T> pattern) {
        return this.with(new PatternCondition<T>("without"){

            @Override
            public boolean accepts(@NotNull T o, ProcessingContext context) {
                if (o == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern$8.accepts must not be null");
                }
                return !pattern.accepts(o, context);
            }
        });
    }

    public String toString() {
        return this.myCondition.toString();
    }

    public static class Capture<T>
    extends ObjectPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/ObjectPattern$Capture.<init> must not be null");
            }
            super(condition);
        }
    }
}

