/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.util.ui.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class StripeTable
extends Table {
    private static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    private static final Color GRID_COLOR = new Color(217, 217, 217);
    private static final CellRendererPane RENDER_PANE = new CellRendererPane();

    public StripeTable(TableModel model) {
        super(model);
        this.setAutoResizeMode(0);
        this.setTableHeader(this.createTableHeader());
        this.getTableHeader().setReorderingAllowed(false);
        this.setOpaque(false);
        this.setGridColor(GRID_COLOR);
        this.setIntercellSpacing(new Dimension(1, 0));
        this.setShowGrid(false);
    }

    private JTableHeader createTableHeader() {
        return new JTableHeader(this.getColumnModel()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JViewport viewport = (JViewport)this.table.getParent();
                if (viewport != null && this.table.getWidth() < viewport.getWidth()) {
                    int x = this.table.getWidth();
                    int width = viewport.getWidth() - this.table.getWidth();
                    StripeTable.paintHeader(g, this.getTable(), x, width);
                }
            }
        };
    }

    private static void paintHeader(Graphics g, JTable table, int x, int width) {
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent(table, "", false, false, -1, 2);
        component.setBounds(0, 0, width, table.getTableHeader().getHeight());
        ((JComponent)component).setOpaque(false);
        RENDER_PANE.paintComponent(g, component, null, x, 0, width, table.getTableHeader().getHeight(), true);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(this.getSelectionModel().isSelectedIndex(row) || row % 2 == 0);
            if (!this.getSelectionModel().isSelectedIndex(row) && row % 2 == 0) {
                component.setBackground(EVEN_ROW_COLOR);
            }
        }
        return component;
    }

    public static JScrollPane createScrollPane(JTable table) {
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setViewport(new StripedViewport(table));
        scrollPane.getViewport().setView(table);
        scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        return scrollPane;
    }

    private static class StripedViewport
    extends JViewport {
        private final JTable myTable;

        public StripedViewport(JTable table) {
            this.myTable = table;
            this.setOpaque(false);
            this.initListeners();
        }

        private void initListeners() {
            PropertyChangeListener listener = this.createTableColumnWidthListener();
            for (int i = 0; i < this.myTable.getColumnModel().getColumnCount(); ++i) {
                this.myTable.getColumnModel().getColumn(i).addPropertyChangeListener(listener);
            }
        }

        private PropertyChangeListener createTableColumnWidthListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    StripedViewport.this.repaint();
                }
            };
        }

        @Override
        protected void paintComponent(Graphics g) {
            int x = 0;
            for (int i = 0; i < this.myTable.getColumnCount(); ++i) {
                TableColumn column = this.myTable.getColumnModel().getColumn(i);
                g.setColor(GRID_COLOR);
                g.drawLine((x += column.getWidth()) - 1, g.getClipBounds().y, x - 1, this.getHeight());
            }
            super.paintComponent(g);
        }
    }
}

