/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NativeFileType
implements FileType {
    private static final Icon ICON = IconLoader.getIcon((String)"/fileTypes/custom.png");
    public static final NativeFileType INSTANCE = new NativeFileType();

    private NativeFileType() {
    }

    @Override
    @NotNull
    public String getName() {
        if ("Native" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/NativeFileType.getName must not return null");
        }
        return "Native";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Files opened in associated applications" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/NativeFileType.getDescription must not return null");
        }
        return "Files opened in associated applications";
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/NativeFileType.getDefaultExtension must not return null");
        }
        return "";
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/NativeFileType.getCharset must not be null");
        }
        return null;
    }

    public static boolean openAssociatedApplication(VirtualFile file) {
        ArrayList<String> commands = new ArrayList<String>();
        if (SystemInfo.isWindows) {
            commands.add("rundll32.exe");
            commands.add("url.dll,FileProtocolHandler");
        } else if (SystemInfo.isMac) {
            commands.add("/usr/bin/open");
        } else if (SystemInfo.isKDE) {
            commands.add("kfmclient");
            commands.add("exec");
        } else if (SystemInfo.isGnome) {
            commands.add("gnome-open");
        } else {
            return false;
        }
        commands.add(file.getPath());
        try {
            Runtime.getRuntime().exec(ArrayUtil.toStringArray(commands));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

