/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parameterInfo;

import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoUtils {
    public static final String DEFAULT_PARAMETER_CLOSE_CHARS = ",){}";

    public static <T extends PsiElement> T findParentOfType(PsiFile file, int offset, Class<T> parentClass) {
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        return PsiTreeUtil.getParentOfType(element, parentClass);
    }

    public static int getCurrentParameterIndex(ASTNode argList, int offset, IElementType delimiterType) {
        int curOffset = argList.getTextRange().getStartOffset();
        if (offset < curOffset) {
            return -1;
        }
        ASTNode[] children = argList.getChildren(null);
        int index = 0;
        for (ASTNode child : children) {
            if (offset < (curOffset += child.getTextLength())) break;
            IElementType type = child.getElementType();
            if (type != delimiterType) continue;
            ++index;
        }
        return index;
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file, int offset, int lbraceOffset, @NotNull ParameterInfoHandlerWithTabActionSupport findArgumentListHelper) {
        PsiElement element;
        int offset1;
        if (findArgumentListHelper == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/parameterInfo/ParameterInfoUtils.findArgumentList must not be null");
        }
        if (file == null) {
            return null;
        }
        CharSequence chars = file.getViewProvider().getContents();
        if (offset >= chars.length()) {
            offset = chars.length() - 1;
        }
        if ((offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)offset, (String)" \t\n\r")) < 0) {
            return null;
        }
        boolean acceptRparenth = true;
        boolean acceptLparenth = false;
        if (offset1 != offset) {
            offset = offset1;
            acceptRparenth = false;
            acceptLparenth = true;
        }
        if ((element = file.findElementAt(offset)) == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        while (true) {
            if (findArgumentListHelper.getArgumentListClass().isInstance(parent)) {
                TextRange range = parent.getTextRange();
                if (!acceptRparenth && offset == range.getEndOffset() - 1) {
                    PsiElement[] children = parent.getChildren();
                    if (children.length == 0) {
                        return null;
                    }
                    PsiElement last = children[children.length - 1];
                    if (last.getNode().getElementType() == findArgumentListHelper.getActualParametersRBraceType()) {
                        parent = parent.getParent();
                        continue;
                    }
                }
                if (!acceptLparenth && offset == range.getStartOffset()) {
                    parent = parent.getParent();
                    continue;
                }
                if (lbraceOffset < 0 || range.getStartOffset() == lbraceOffset) break;
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof PsiFile || parent == null) {
                return null;
            }
            parent = parent.getParent();
        }
        PsiElement listParent = parent.getParent();
        for (Class c : findArgumentListHelper.getArgumentListAllowedParentClasses()) {
            if (!c.isInstance(listParent)) continue;
            return (E)parent;
        }
        return null;
    }
}

