/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import sun.misc.CompoundEnumeration;

public class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final File myLibDirectory;

    public PluginClassLoader(List<URL> urls, ClassLoader[] parents, PluginId pluginId, File pluginRoot) {
        super(urls, null, true, true);
        this.myParents = parents;
        this.myPluginId = pluginId;
        File file = new File(pluginRoot, "lib");
        this.myLibDirectory = file.exists() ? file : null;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.loadClassInsideSelf(name);
        if (c == null) {
            c = this.loadClassFromParents(name);
        }
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        PluginManager.addPluginClass(name, this.myPluginId);
        throw new ClassNotFoundException(name);
    }

    @Nullable
    private Class loadClassFromParents(String name) {
        for (ClassLoader parent : this.myParents) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException ignoreAndContinue) {
            }
        }
        return null;
    }

    @Nullable
    private synchronized Class loadClassInsideSelf(String name) {
        Class c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        c = this._findClass(name);
        if (c != null) {
            PluginManager.addPluginClass(c.getName(), this.myPluginId);
        }
        return c;
    }

    /*
     * Exception decompiling
     */
    public URL findResource(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public InputStream getResourceAsStream(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<URL> findResources(String name) throws IOException {
        CompoundEnumeration compoundEnumeration;
        block4: {
            long started = 0L;
            try {
                Enumeration[] resources = new Enumeration[this.myParents.length + 1];
                resources[0] = super.findResources(name);
                for (int idx = 0; idx < this.myParents.length; ++idx) {
                    resources[idx + 1] = PluginClassLoader.fetchResources(this.myParents[idx], name);
                }
                compoundEnumeration = new CompoundEnumeration(resources);
                long doneFor = 0L;
                if (doneFor <= 10000000L) break block4;
                System.out.println(doneFor / 1000000L + " ms for " + (this.myPluginId != null ? this.myPluginId.getIdString() : null) + ", find resources:" + name);
            }
            catch (Throwable throwable) {
                long doneFor = 0L;
                if (doneFor > 10000000L) {
                    System.out.println(doneFor / 1000000L + " ms for " + (this.myPluginId != null ? this.myPluginId.getIdString() : null) + ", find resources:" + name);
                }
                throw throwable;
            }
        }
        return compoundEnumeration;
    }

    protected String findLibrary(String libName) {
        if (this.myLibDirectory == null) {
            return null;
        }
        File libraryFile = new File(this.myLibDirectory, System.mapLibraryName(libName));
        return libraryFile.exists() ? libraryFile.getAbsolutePath() : null;
    }

    private static URL fetchResource(ClassLoader cl, String resourceName) {
        try {
            Method findResourceMethod = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResource");
            return (URL)findResourceMethod.invoke((Object)cl, resourceName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Enumeration fetchResources(ClassLoader cl, String resourceName) {
        try {
            Method findResourceMethod = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResources");
            if (findResourceMethod == null) {
                return null;
            }
            return (Enumeration)findResourceMethod.invoke((Object)cl, resourceName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Method getFindResourceMethod(Class clClass, String methodName) {
        try {
            Method declaredMethod = clClass.getDeclaredMethod(methodName, String.class);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            Class superclass = clClass.getSuperclass();
            if (superclass == null || superclass.equals(Object.class)) {
                return null;
            }
            return PluginClassLoader.getFindResourceMethod(superclass, methodName);
        }
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    public String toString() {
        return "PluginClassloader[" + this.myPluginId + "]";
    }
}

