/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.openapi.util.Key;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public abstract class LogFilterModel {
    private Pattern myCustomPattern;

    public void updateCustomFilter(String filter) {
        this.myCustomPattern = null;
    }

    public abstract String getCustomFilter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pattern getCustomPattern() {
        String customFilter = this.getCustomFilter();
        if (this.myCustomPattern == null && customFilter != null) {
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                for (int i = 0; i < customFilter.length(); ++i) {
                    char c = customFilter.charAt(i);
                    if (Character.isLetterOrDigit(c)) {
                        buf.append(Character.toUpperCase(c));
                        continue;
                    }
                    buf.append("\\").append(c);
                }
                this.myCustomPattern = Pattern.compile(".*" + buf + ".*", 32);
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }
        return this.myCustomPattern;
    }

    public abstract void addFilterListener(LogFilterListener var1);

    public abstract void removeFilterListener(LogFilterListener var1);

    public boolean isApplicable(String line) {
        Pattern pattern;
        return this.getCustomFilter() == null || (pattern = this.getCustomPattern()) == null || pattern.matcher(line.toUpperCase()).matches();
    }

    public abstract List<? extends LogFilter> getLogFilters();

    public abstract boolean isFilterSelected(LogFilter var1);

    public abstract void selectFilter(LogFilter var1);

    @Nullable
    public abstract Key processLine(String var1);
}

