/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupElement
extends UserDataHolderBase {
    public static final LookupElement[] EMPTY_ARRAY = new LookupElement[0];
    private PrefixMatcher myPrefixMatcher = PrefixMatcher.FALSE_MATCHER;

    @NotNull
    public abstract String getLookupString();

    public Set<String> getAllLookupStrings() {
        return Collections.singleton(this.getLookupString());
    }

    public boolean setPrefixMatcher(@NotNull PrefixMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElement.setPrefixMatcher must not be null");
        }
        this.myPrefixMatcher = matcher;
        return this.isPrefixMatched();
    }

    public final boolean isPrefixMatched() {
        return this.myPrefixMatcher.prefixMatches(this);
    }

    @NotNull
    public final PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myPrefixMatcher;
        if (prefixMatcher == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElement.getPrefixMatcher must not return null");
        }
        return prefixMatcher;
    }

    @NotNull
    public Object getObject() {
        LookupElement lookupElement = this;
        if (lookupElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElement.getObject must not return null");
        }
        return lookupElement;
    }

    public void handleInsert(InsertionContext context) {
    }

    public String toString() {
        return this.getLookupString();
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
    }

    @Nullable
    public <T> T as(Class<T> aClass) {
        return (T)((Object)(aClass.isInstance((Object)this) ? this : null));
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

