/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.PackageSetChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.ui.CopyrightProfilesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsPanel
extends PanelWithButtons {
    private final Project myProject;
    private final CopyrightProfilesPanel myProfilesModel;
    private final CopyrightManager myManager;
    private final TableView<ScopeSetting> myScopeMappingTable;
    private final ListTableModel<ScopeSetting> myScopeMappingModel;
    private final JComboBox myProfilesComboBox = new JComboBox();
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private final HyperlinkLabel myScopesLink = new HyperlinkLabel();
    private final ColumnInfo<ScopeSetting, CopyrightProfile> SETTING = new ColumnInfo<ScopeSetting, CopyrightProfile>("Copyright"){

        public CopyrightProfile valueOf(ScopeSetting object) {
            return object.getProfile();
        }

        public boolean isCellEditable(ScopeSetting o) {
            return true;
        }

        public TableCellRenderer getRenderer(final ScopeSetting scopeSetting) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!isSelected) {
                        this.setForeground(ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().get(scopeSetting.getProfileName()) == null ? Color.red : UIUtil.getTableForeground());
                    }
                    this.setText(scopeSetting.getProfileName());
                    return rendererComponent;
                }
            };
        }

        public TableCellEditor getEditor(ScopeSetting scopeSetting) {
            return new AbstractTableCellEditor(){
                private ComboBox myProfilesCombo;

                public Object getCellEditorValue() {
                    return this.myProfilesCombo.getSelectedItem();
                }

                public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
                    Collection<CopyrightProfile> copyrights = ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().values();
                    this.myProfilesCombo = new ComboBox((Object[])copyrights.toArray(new CopyrightProfile[copyrights.size()]), 60);
                    this.myProfilesCombo.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (table.isEditing()) {
                                this.stopCellEditing();
                            }
                        }
                    });
                    this.myProfilesCombo.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                            this.setText(((CopyrightProfile)((Object)value)).getName());
                            return rendererComponent;
                        }
                    });
                    return this.myProfilesCombo;
                }
            };
        }

        public void setValue(ScopeSetting scopeSetting, CopyrightProfile copyrightProfile) {
            if (copyrightProfile != null) {
                scopeSetting.setProfile(copyrightProfile);
            }
        }
    };
    private final ColumnInfo<ScopeSetting, NamedScope> SCOPE = new ColumnInfo<ScopeSetting, NamedScope>("Scope"){

        public boolean isCellEditable(ScopeSetting mapping) {
            return true;
        }

        public TableCellRenderer getRenderer(ScopeSetting mapping) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setText(value == null ? "" : ((NamedScope)value).getName());
                    return this;
                }
            };
        }

        public TableCellEditor getEditor(ScopeSetting mapping) {
            return new AbstractTableCellEditor(){
                private PackageSetChooserCombo myCombo;

                public Object getCellEditorValue() {
                    return this.myCombo.getSelectedScope();
                }

                public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myCombo = new PackageSetChooserCombo(ProjectSettingsPanel.this.myProject, value == null ? null : ((NamedScope)value).getName(), false);
                    this.myCombo.getComboBox().addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (table.isEditing()) {
                                this.stopCellEditing();
                            }
                        }
                    });
                    return new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)this.myCombo, (TableCellEditor)((Object)this));
                }
            };
        }

        public NamedScope valueOf(ScopeSetting mapping) {
            return mapping.getScope();
        }

        public void setValue(ScopeSetting mapping, NamedScope set) {
            mapping.setScope(set);
        }
    };

    public ProjectSettingsPanel(Project project, CopyrightProfilesPanel profilesModel) {
        this.myProject = project;
        this.myProfilesModel = profilesModel;
        this.myProfilesModel.addItemsChangeListener(new Runnable(){

            @Override
            public void run() {
                Object selectedItem = ProjectSettingsPanel.this.myProfilesComboBox.getSelectedItem();
                ProjectSettingsPanel.this.fillCopyrightProfiles();
                ProjectSettingsPanel.this.myProfilesComboBox.setSelectedItem(selectedItem);
                ArrayList<ScopeSetting> toRemove = new ArrayList<ScopeSetting>();
                for (ScopeSetting setting : ProjectSettingsPanel.this.myScopeMappingModel.getItems()) {
                    if (setting.getProfile() != null) continue;
                    toRemove.add(setting);
                }
                for (ScopeSetting setting : toRemove) {
                    ProjectSettingsPanel.this.myScopeMappingModel.removeRow(ProjectSettingsPanel.this.myScopeMappingModel.indexOf((Object)setting));
                }
                ProjectSettingsPanel.this.updateButtons();
            }
        });
        this.myManager = CopyrightManager.getInstance(project);
        this.myScopeMappingModel = new ListTableModel(new ColumnInfo[]{this.SCOPE, this.SETTING}, new ArrayList(), 0);
        this.myScopeMappingTable = new TableView(this.myScopeMappingModel);
        this.fillCopyrightProfiles();
        this.myProfilesComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText("No copyright");
                } else {
                    this.setText(((CopyrightProfile)((Object)value)).getName());
                }
                return rendererComponent;
            }
        });
        this.myScopeMappingTable.setRowHeight(this.myProfilesComboBox.getPreferredSize().height);
        this.myScopeMappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectSettingsPanel.this.updateButtons();
            }
        });
        this.initPanel();
        this.myScopesLink.setVisible(!this.myProject.isDefault());
        this.myScopesLink.setHyperlinkText("Select Scopes to add new scopes or modify existing ones");
        this.myScopesLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                OptionsEditor optionsEditor;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (optionsEditor = (OptionsEditor)OptionsEditor.KEY.getData(DataManager.getInstance().getDataContext())) != null) {
                    optionsEditor.select((Configurable)ScopeChooserConfigurable.getInstance((Project)ProjectSettingsPanel.this.myProject));
                }
            }
        });
    }

    private void updateButtons() {
        this.myAddButton.setEnabled(!this.myProfilesModel.getAllProfiles().isEmpty());
        int index = this.myScopeMappingTable.getSelectedRow();
        if (0 <= index && index < this.myScopeMappingModel.getRowCount()) {
            this.myRemoveButton.setEnabled(true);
            this.myMoveUpButton.setEnabled(index > 0);
            this.myMoveDownButton.setEnabled(index < this.myScopeMappingModel.getRowCount() - 1);
        } else {
            this.myRemoveButton.setEnabled(false);
            this.myMoveUpButton.setEnabled(false);
            this.myMoveDownButton.setEnabled(false);
        }
    }

    @Nullable
    protected String getLabelText() {
        return null;
    }

    protected JButton[] createButtons() {
        this.myAddButton = new JButton("Add");
        this.myAddButton.setMnemonic('d');
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.stopEditing((JTable)ProjectSettingsPanel.this.myScopeMappingTable);
                ArrayList<ScopeSetting> newList = new ArrayList<ScopeSetting>(ProjectSettingsPanel.this.myScopeMappingModel.getItems());
                newList.add(new ScopeSetting(DefaultScopesProvider.getAllScope(), ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().values().iterator().next()));
                ProjectSettingsPanel.this.myScopeMappingModel.setItems(newList);
                TableUtil.editCellAt((JTable)ProjectSettingsPanel.this.myScopeMappingTable, (int)(ProjectSettingsPanel.this.myScopeMappingModel.getRowCount() - 1), (int)0);
            }
        });
        this.myRemoveButton = new JButton("Remove");
        this.myRemoveButton.setMnemonic('R');
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.stopEditing((JTable)ProjectSettingsPanel.this.myScopeMappingTable);
                int index = ProjectSettingsPanel.this.myScopeMappingTable.getSelectedRow();
                if (0 <= index && index < ProjectSettingsPanel.this.myScopeMappingModel.getRowCount()) {
                    ProjectSettingsPanel.this.myScopeMappingModel.removeRow(index);
                    if (index < ProjectSettingsPanel.this.myScopeMappingModel.getRowCount()) {
                        ProjectSettingsPanel.this.myScopeMappingTable.setRowSelectionInterval(index, index);
                    } else if (index > 0) {
                        ProjectSettingsPanel.this.myScopeMappingTable.setRowSelectionInterval(index - 1, index - 1);
                    }
                    ProjectSettingsPanel.this.updateButtons();
                }
                ProjectSettingsPanel.this.myScopeMappingTable.requestFocus();
            }
        });
        this.myMoveUpButton = new JButton("Move Up");
        this.myMoveUpButton.setMnemonic('U');
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.moveSelectedItemsUp((JTable)ProjectSettingsPanel.this.myScopeMappingTable);
            }
        });
        this.myMoveDownButton = new JButton("Move Down");
        this.myMoveDownButton.setMnemonic('D');
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.moveSelectedItemsDown((JTable)ProjectSettingsPanel.this.myScopeMappingTable);
            }
        });
        return new JButton[]{this.myAddButton, this.myRemoveButton, this.myMoveUpButton, this.myMoveDownButton};
    }

    private void fillCopyrightProfiles() {
        DefaultComboBoxModel boxModel = (DefaultComboBoxModel)this.myProfilesComboBox.getModel();
        boxModel.removeAllElements();
        boxModel.addElement(null);
        for (CopyrightProfile profile : this.myProfilesModel.getAllProfiles().values()) {
            boxModel.addElement(profile);
        }
    }

    protected JComponent createMainComponent() {
        return new JScrollPane((Component)this.myScopeMappingTable);
    }

    public JComponent getMainComponent() {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        LabeledComponent component = new LabeledComponent();
        component.setText("Default &project copyright:");
        component.setLabelLocation("West");
        component.setComponent((JComponent)this.myProfilesComboBox);
        panel.add((Component)component, "North");
        panel.add((Component)((Object)this), "Center");
        panel.add((Component)this.myScopesLink, "South");
        return panel;
    }

    public boolean isModified() {
        Map<String, String> map;
        Object selected;
        CopyrightProfile defaultCopyright = this.myManager.getDefaultCopyright();
        if (defaultCopyright != (selected = this.myProfilesComboBox.getSelectedItem())) {
            if (selected == null) {
                return true;
            }
            if (defaultCopyright == null) {
                return true;
            }
            if (!defaultCopyright.equals(selected)) {
                return true;
            }
        }
        if ((map = this.myManager.getCopyrightsMapping()).size() != this.myScopeMappingModel.getItems().size()) {
            return true;
        }
        Iterator<String> iterator = map.keySet().iterator();
        for (ScopeSetting setting : this.myScopeMappingModel.getItems()) {
            NamedScope scope = setting.getScope();
            if (!iterator.hasNext()) {
                return true;
            }
            String scopeName = iterator.next();
            if (!Comparing.strEqual((String)scopeName, (String)scope.getName())) {
                return true;
            }
            String profileName = map.get(scope.getName());
            if (profileName == null) {
                return true;
            }
            if (profileName.equals(setting.getProfileName())) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        ArrayList<CopyrightProfile> profiles = new ArrayList<CopyrightProfile>(this.myManager.getCopyrights());
        this.myManager.clearCopyrights();
        for (CopyrightProfile profile : profiles) {
            this.myManager.addCopyright(profile);
        }
        List settingList = this.myScopeMappingModel.getItems();
        for (ScopeSetting scopeSetting : settingList) {
            this.myManager.mapCopyright(scopeSetting.getScope().getName(), scopeSetting.getProfileName());
        }
        this.myManager.setDefaultCopyright((CopyrightProfile)((Object)this.myProfilesComboBox.getSelectedItem()));
    }

    public void reset() {
        this.myProfilesComboBox.setSelectedItem((Object)this.myManager.getDefaultCopyright());
        ArrayList<ScopeSetting> mappings = new ArrayList<ScopeSetting>();
        Map<String, String> copyrights = this.myManager.getCopyrightsMapping();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)this.myProject);
        for (String scopeName : copyrights.keySet()) {
            NamedScope scope = manager.getScope(scopeName);
            if (scope != null) {
                mappings.add(new ScopeSetting(scope, copyrights.get(scopeName)));
                continue;
            }
            this.myManager.unmapCopyright(scopeName);
        }
        this.myScopeMappingModel.setItems(mappings);
        this.updateButtons();
    }

    private class ScopeSetting {
        private NamedScope myScope;
        private CopyrightProfile myProfile;
        private String myProfileName;

        private ScopeSetting(NamedScope scope, CopyrightProfile profile) {
            this.myScope = scope;
            this.myProfile = profile;
            if (this.myProfile != null) {
                this.myProfileName = this.myProfile.getName();
            }
        }

        public ScopeSetting(NamedScope scope, String profile) {
            this.myScope = scope;
            this.myProfileName = profile;
        }

        public CopyrightProfile getProfile() {
            if (this.myProfileName != null) {
                this.myProfile = ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().get(this.getProfileName());
            }
            return this.myProfile;
        }

        public void setProfile(@NotNull CopyrightProfile profile) {
            if (profile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/maddyhome/idea/copyright/ui/ProjectSettingsPanel$ScopeSetting.setProfile must not be null");
            }
            this.myProfile = profile;
            this.myProfileName = profile.getName();
        }

        public NamedScope getScope() {
            return this.myScope;
        }

        public void setScope(NamedScope scope) {
            this.myScope = scope;
        }

        public String getProfileName() {
            return this.myProfile != null ? this.myProfile.getName() : this.myProfileName;
        }
    }
}

