/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduceParameter.java2groovy;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.util.javadoc.MethodJavaDocHelper;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduceParameter.java2groovy.FieldConflictsResolver;
import org.jetbrains.plugins.groovy.refactoring.introduceParameter.java2groovy.OldReferencesResolver;

public class GroovyIntroduceParameterMethodUsagesProcessor
implements IntroduceParameterMethodUsagesProcessor {
    private static final Language myLanguage = GroovyFileType.GROOVY_LANGUAGE;

    private static boolean isGroovyUsage(UsageInfo usage) {
        PsiElement el = usage.getElement();
        return el != null && el.getLanguage().is(myLanguage);
    }

    public boolean isMethodUsage(UsageInfo usage) {
        return GroovyRefactoringUtil.isMethodUsage(usage.getElement()) && GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage);
    }

    public void findConflicts(IntroduceParameterData data, UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
        HashSet<UsageInfo> groovyUsages = new HashSet<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (!this.isMethodUsage(usage)) continue;
            groovyUsages.add(usage);
        }
        if (groovyUsages.size() == 0) {
            return;
        }
        data.getParameterInitializer().accept((PsiElementVisitor)new InitializerVisitor(conflicts));
    }

    public boolean processChangeMethodUsage(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        int lastNonVararg;
        PsiParameter[] parameters;
        if (!this.isMethodUsage(usage)) {
            return true;
        }
        GrCall callExpression = GroovyRefactoringUtil.getCallExpressionByMethodReference(usage.getElement());
        GrArgumentList argList = callExpression.getArgumentList();
        GrExpression[] oldArgs = argList.getExpressionArguments();
        GrExpression anchor = !data.getMethodToSearchFor().isVarArgs() ? GroovyIntroduceParameterMethodUsagesProcessor.getLast(oldArgs) : ((parameters = data.getMethodToSearchFor().getParameterList().getParameters()).length > oldArgs.length ? GroovyIntroduceParameterMethodUsagesProcessor.getLast(oldArgs) : ((lastNonVararg = parameters.length - 2) >= 0 ? oldArgs[lastNonVararg] : null));
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)argList, PsiMethod.class);
        if (method != null && GroovyIntroduceParameterMethodUsagesProcessor.isMethodInUsages(method, usages, data)) {
            argList.addAfter(GroovyPsiElementFactory.getInstance(data.getProject()).createExpressionFromText(data.getParameterName()), anchor);
        } else {
            ChangeContextUtil.encodeContextInfo((PsiElement)data.getParameterInitializer(), (boolean)true);
            GrExpression grInitializer = GroovyRefactoringUtil.convertJavaExpr2GroovyExpr((PsiElement)data.getParameterInitializer());
            GrExpression newArg = (GrExpression)argList.addAfter(grInitializer, anchor);
            new OldReferencesResolver(callExpression, newArg, data.getMethodToReplaceIn(), data.getReplaceFieldsWithGetters(), data.getParameterInitializer()).resolve();
            ChangeContextUtil.clearContextInfo((PsiElement)data.getParameterInitializer());
        }
        GroovyIntroduceParameterMethodUsagesProcessor.removeParametersFromCall(callExpression.getArgumentList(), data.getParametersToRemove());
        return false;
    }

    private static boolean isMethodInUsages(PsiMethod method, UsageInfo[] usages, IntroduceParameterData data) {
        PsiManager manager = PsiManager.getInstance((Project)data.getProject());
        for (UsageInfo info : usages) {
            if (info instanceof DefaultConstructorImplicitUsageInfo || !manager.areElementsEquivalent(info.getElement(), (PsiElement)method)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static GrExpression getLast(GrExpression[] oldArgs) {
        GrExpression anchor = oldArgs.length > 0 ? oldArgs[oldArgs.length - 1] : null;
        return anchor;
    }

    private static void removeParametersFromCall(GrArgumentList argList, TIntArrayList parametersToRemove) {
        final GrExpression[] exprs = argList.getExpressionArguments();
        parametersToRemove.forEachDescending(new TIntProcedure(){

            public boolean execute(int paramNum) {
                try {
                    exprs[paramNum].delete();
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
                return true;
            }
        });
    }

    public boolean processChangeMethodSignature(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(usage.getElement() instanceof GrMethod) || !GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage)) {
            return true;
        }
        GrMethod method = (GrMethod)usage.getElement();
        FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(data.getParameterName(), method.getBlock());
        final MethodJavaDocHelper javaDocHelper = new MethodJavaDocHelper((PsiMethod)method);
        PsiManager manager = method.getManager();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
        final PsiParameter[] parameters = method.getParameterList().getParameters();
        data.getParametersToRemove().forEachDescending(new TIntProcedure(){

            public boolean execute(int paramNum) {
                try {
                    PsiParameter param = parameters[paramNum];
                    PsiDocTag tag = javaDocHelper.getTagForParameter(param);
                    if (tag != null) {
                        tag.delete();
                    }
                    param.delete();
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
                return true;
            }
        });
        GrParameter parameter = factory.createParameter(data.getParameterName(), data.getForcedType().getCanonicalText(), method);
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)data.isDeclareFinal());
        PsiParameter anchorParameter = GroovyIntroduceParameterMethodUsagesProcessor.getAnchorParameter(method);
        GrParameterList parameterList = method.getParameterList();
        parameter = (PsiParameter)parameterList.addAfter(parameter, (PsiElement)anchorParameter);
        JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)parameter);
        PsiDocTag tagForAnchorParameter = javaDocHelper.getTagForParameter(anchorParameter);
        javaDocHelper.addParameterAfter(data.getParameterName(), tagForAnchorParameter);
        fieldConflictsResolver.fix();
        return false;
    }

    @Nullable
    private static PsiParameter getAnchorParameter(PsiMethod methodToReplaceIn) {
        PsiParameterList parameterList = methodToReplaceIn.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        int length = parameters.length;
        PsiParameter anchorParameter = !methodToReplaceIn.isVarArgs() ? (length > 0 ? parameters[length - 1] : null) : (length > 1 ? parameters[length - 2] : null);
        return anchorParameter;
    }

    public boolean processAddDefaultConstructor(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) {
        if (!(usage.getElement() instanceof PsiClass) || !GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage)) {
            return true;
        }
        PsiClass aClass = (PsiClass)usage.getElement();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(data.getProject());
        GrMethod constructor = factory.createConstructorFromText(aClass.getName(), ArrayUtil.EMPTY_STRING_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, "{}");
        constructor = (GrMethod)aClass.add((PsiElement)constructor);
        PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), (boolean)true);
        this.processAddSuperCall(data, new UsageInfo((PsiElement)constructor), usages);
        constructor = (GrMethod)CodeStyleManager.getInstance((Project)data.getProject()).reformat((PsiElement)constructor);
        return false;
    }

    public boolean processAddSuperCall(IntroduceParameterData data, UsageInfo usage, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(usage.getElement() instanceof GrMethod) || !GroovyIntroduceParameterMethodUsagesProcessor.isGroovyUsage(usage)) {
            return true;
        }
        GrMethod constructor = (GrMethod)usage.getElement();
        if (!constructor.isConstructor()) {
            return true;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(data.getProject());
        GrExpression superCall = (GrExpression)factory.createStatementFromText("super();");
        superCall = (GrExpression)CodeStyleManager.getInstance((Project)data.getProject()).reformat((PsiElement)superCall);
        GrOpenBlock body = constructor.getBlock();
        GrStatement[] statements = body.getStatements();
        superCall = statements.length > 0 ? (GrExpression)body.addStatementBefore(superCall, statements[0]) : (GrExpression)body.addStatementBefore(superCall, null);
        this.processChangeMethodUsage(data, new UsageInfo((PsiElement)((GrMethodCallExpression)superCall).getInvokedExpression()), usages);
        return false;
    }

    private static class InitializerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final MultiMap<PsiElement, String> conflicts;

        private InitializerVisitor(MultiMap<PsiElement, String> conflicts) {
            this.conflicts = conflicts;
        }

        public void visitNewExpression(PsiNewExpression expression) {
            PsiAnonymousClass anonymousClass;
            super.visitNewExpression(expression);
            PsiExpression qualifier = expression.getQualifier();
            if (qualifier != null) {
                this.conflicts.putValue((Object)qualifier, (Object)GroovyRefactoringBundle.message("groovy.does.not.support.inner.classes.but.it.is.used.in.parameter.initializer", new Object[0]));
            }
            if ((anonymousClass = expression.getAnonymousClass()) != null) {
                this.conflicts.putValue((Object)anonymousClass, (Object)GroovyRefactoringBundle.message("groovy.does.not.support.anonymous.classes.but.it.is.used.in.parameter.initializer", new Object[0]));
            }
        }
    }
}

