/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.java.ClassElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrWildcardTypeArgument;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyBaseElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeDefinitionImpl
extends GroovyBaseElementImpl<GrTypeDefinitionStub>
implements GrTypeDefinition {
    private volatile PsiClass[] myInnerClasses;
    private volatile List<PsiMethod> myMethods;
    private volatile GrMethod[] myGroovyMethods;
    private volatile GrMethod[] myConstructors;

    public GrTypeDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.<init> must not be null");
        }
        super(node);
    }

    protected GrTypeDefinitionImpl(GrTypeDefinitionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitTypeDefinition(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null) {
            return containingClass.getQualifiedName() + "." + this.getName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFile) {
            String packageName = ((GroovyFile)parent).getPackageName();
            return packageName.length() > 0 ? packageName + "." + this.getName() : this.getName();
        }
        return null;
    }

    @Override
    public GrWildcardTypeArgument[] getTypeParametersGroovy() {
        return (GrWildcardTypeArgument[])this.findChildrenByClass(GrWildcardTypeArgument.class);
    }

    @Override
    @Nullable
    public GrTypeDefinitionBody getBody() {
        return (GrTypeDefinitionBody)this.findChildByType(GroovyElementTypes.CLASS_BODY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GrMembersDeclaration[] getMemberDeclarations() {
        GrMembersDeclaration[] grMembersDeclarationArray;
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            grMembersDeclarationArray = GrMembersDeclaration.EMPTY_ARRAY;
            if (GrMembersDeclaration.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getMemberDeclarations must not return null");
            return grMembersDeclarationArray;
        }
        grMembersDeclarationArray = body.getMemberDeclarations();
        if (grMembersDeclarationArray != null) return grMembersDeclarationArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getMemberDeclarations must not return null");
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return GrTypeDefinitionImpl.this.getName();
            }

            @Nullable
            public String getLocationString() {
                PsiFile file = GrTypeDefinitionImpl.this.getContainingFile();
                if (file instanceof GroovyFile) {
                    GroovyFile groovyFile = (GroovyFile)file;
                    return groovyFile.getPackageName().length() > 0 ? "(" + groovyFile.getPackageName() + ")" : "";
                }
                return "";
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return GrTypeDefinitionImpl.this.getIcon(3);
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                return null;
            }
        };
    }

    @Override
    @Nullable
    public GrExtendsClause getExtendsClause() {
        return (GrExtendsClause)this.findChildByType((IElementType)GroovyElementTypes.EXTENDS_CLAUSE);
    }

    @Override
    @Nullable
    public GrImplementsClause getImplementsClause() {
        return (GrImplementsClause)this.findChildByType((IElementType)GroovyElementTypes.IMPLEMENTS_CLAUSE);
    }

    @Override
    public String[] getSuperClassNames() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getSuperClassNames();
        }
        return (String[])ArrayUtil.mergeArrays((Object[])this.getExtendsNames(), (Object[])this.getImplementsNames(), String.class);
    }

    protected String[] getImplementsNames() {
        GrImplementsClause implementsClause = this.getImplementsClause();
        GrCodeReferenceElement[] implementsRefs = implementsClause != null ? implementsClause.getReferenceElements() : GrCodeReferenceElement.EMPTY_ARRAY;
        ArrayList<String> implementsNames = new ArrayList<String>(implementsRefs.length);
        for (GrCodeReferenceElement ref : implementsRefs) {
            String name = ref.getReferenceName();
            if (name == null) continue;
            implementsNames.add(name);
        }
        return ArrayUtil.toStringArray(implementsNames);
    }

    protected String[] getExtendsNames() {
        GrExtendsClause extendsClause = this.getExtendsClause();
        GrCodeReferenceElement[] extendsRefs = extendsClause != null ? extendsClause.getReferenceElements() : GrCodeReferenceElement.EMPTY_ARRAY;
        ArrayList<String> extendsNames = new ArrayList<String>(extendsRefs.length);
        for (GrCodeReferenceElement ref : extendsRefs) {
            String name = ref.getReferenceName();
            if (name == null) continue;
            extendsNames.add(name);
        }
        return ArrayUtil.toStringArray(extendsNames);
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement result = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (result != null);
        PsiElement psiElement = result;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getNameIdentifierGroovy must not return null");
        }
        return psiElement;
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    public void delete() throws IncorrectOperationException {
        GroovyFileImpl file;
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFileImpl && (file = (GroovyFileImpl)parent).getTypeDefinitions().length == 1 && !file.isScript()) {
            file.delete();
            return;
        }
        ASTNode astNode = parent.getNode();
        if (astNode != null) {
            astNode.removeChild(this.getNode());
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.processDeclarations must not be null");
        }
        return GrClassImplUtil.processDeclarations(this, processor, state, lastParent, place);
    }

    @Override
    public String getName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return PsiImplUtil.getName(this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return GrClassImplUtil.isClassEquivalentTo(this, another);
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    @Nullable
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Nullable
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = GrClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getExtendsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = GrClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getImplementsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this);
    }

    public PsiClass[] getInterfaces() {
        return GrClassImplUtil.getInterfaces(this);
    }

    @NotNull
    public final PsiClass[] getSupers() {
        PsiClass[] psiClassArray = GrClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getSupers must not return null");
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = GrClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GrField[] getFields() {
        GrField[] grFieldArray;
        GrTypeDefinitionBody body = this.getBody();
        if (body != null) {
            grFieldArray = body.getFields();
            if (grFieldArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getFields must not return null");
            return grFieldArray;
        }
        grFieldArray = GrField.EMPTY_ARRAY;
        if (GrField.EMPTY_ARRAY != null) return grFieldArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getFields must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GrClassInitializer[] getInitializersGroovy() {
        GrClassInitializer[] grClassInitializerArray;
        GrTypeDefinitionBody body = this.getBody();
        if (body != null) {
            grClassInitializerArray = body.getInitializers();
            if (grClassInitializerArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getInitializersGroovy must not return null");
            return grClassInitializerArray;
        }
        grClassInitializerArray = GrClassInitializer.EMPTY_ARRAY;
        if (GrClassInitializer.EMPTY_ARRAY != null) return grClassInitializerArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getInitializersGroovy must not return null");
    }

    @NotNull
    public PsiMethod[] getMethods() {
        List<PsiMethod> cached = this.myMethods;
        if (cached == null) {
            cached = new ArrayList<PsiMethod>();
            GrTypeDefinitionBody body = this.getBody();
            if (body != null) {
                cached.addAll(body.getMethods());
            }
            this.myMethods = cached;
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(cached);
        GrClassImplUtil.addGroovyObjectMethods(this, result);
        PsiMethod[] psiMethodArray = result.toArray(new PsiMethod[result.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public GrMethod[] getGroovyMethods() {
        GrMethod[] cached = this.myGroovyMethods;
        if (cached == null) {
            GrTypeDefinitionBody body = this.getBody();
            cached = body != null ? body.getGroovyMethods() : GrMethod.EMPTY_ARRAY;
            this.myGroovyMethods = cached;
        }
        if (cached == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getGroovyMethods must not return null");
        }
        return cached;
    }

    public void subtreeChanged() {
        this.myMethods = null;
        this.myInnerClasses = null;
        this.myConstructors = null;
        this.myGroovyMethods = null;
        super.subtreeChanged();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] cached = this.myConstructors;
        if (cached == null) {
            ArrayList<GrMethod> result = new ArrayList<GrMethod>();
            for (PsiMethod method : this.getMethods()) {
                if (!method.isConstructor()) continue;
                result.add((GrMethod)method);
            }
            cached = result.toArray(new GrMethod[result.size()]);
            this.myConstructors = cached;
        }
        if (cached == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getConstructors must not return null");
        }
        return cached;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] inners = this.myInnerClasses;
        if (inners == null) {
            GrTypeDefinitionBody body = this.getBody();
            inners = body != null ? body.getInnerClasses() : PsiClass.EMPTY_ARRAY;
            this.myInnerClasses = inners;
        }
        if (inners == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getInnerClasses must not return null");
        }
        return inners;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getInitializers must not return null");
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = GrClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = GrClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases);
    }

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findCodeMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findCodeMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.findCodeMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(this, name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findCodeMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findCodeMethodsByName(this, name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.findCodeMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = GrClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.findMethodsAndTheirSubstitutorsByName must not return null");
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = GrClassImplUtil.getAllMethodsAndTheirSubstitutors(this);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getAllMethodsAndTheirSubstitutors must not return null");
        }
        return list;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return null;
    }

    @Nullable
    public PsiJavaToken getLBrace() {
        return null;
    }

    @Nullable
    public PsiJavaToken getRBrace() {
        return null;
    }

    @Override
    @Nullable
    public PsiElement getLBraceGroovy() {
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            return null;
        }
        return body.getLBrace();
    }

    @Override
    @Nullable
    public PsiElement getRBraceGroovy() {
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            return null;
        }
        return body.getRBrace();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    @Nullable
    public PsiElement getScope() {
        return null;
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.isInheritor must not be null");
        }
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    @Nullable
    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        return null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection collection = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)this);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getVisibleSignatures must not return null");
        }
        return collection;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.setName must not be null");
        }
        boolean renameFile = this.isRenameFileOnClassRenaming();
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        if (renameFile) {
            GroovyFileBase file = (GroovyFileBase)this.getContainingFile();
            file.setName(name + "." + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension());
        }
        return this;
    }

    @Override
    @Nullable
    public GrModifierList getModifierList() {
        return (GrModifierList)this.findChildByType((IElementType)GroovyElementTypes.MODIFIERS);
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.hasModifierProperty must not be null");
        }
        GrModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.findChildByClass(GrTypeParameterList.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameter[] grTypeParameterArray;
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            grTypeParameterArray = list.getTypeParameters();
            if (grTypeParameterArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getTypeParameters must not return null");
            return grTypeParameterArray;
        }
        grTypeParameterArray = GrTypeParameter.EMPTY_ARRAY;
        if (GrTypeParameter.EMPTY_ARRAY != null) return grTypeParameterArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.getTypeParameters must not return null");
    }

    @Nullable
    public Icon getIcon(int flags) {
        Icon icon = this.getIconInner();
        boolean isLocked = (flags & 2) != 0 && !this.isWritable();
        RowIcon rowIcon = ElementBase.createLayeredIcon((Icon)icon, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)isLocked));
        if ((flags & 1) != 0) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)this.getModifierList(), (RowIcon)rowIcon);
        }
        return rowIcon;
    }

    private Icon getIconInner() {
        if (this.isAnnotationType()) {
            return GroovyIcons.ANNOTATION_TYPE;
        }
        if (this.isInterface()) {
            return GroovyIcons.INTERFACE;
        }
        if (this.isEnum()) {
            return GroovyIcons.ENUM;
        }
        if (this.hasModifierProperty("abstract")) {
            return GroovyIcons.ABSTRACT_CLASS;
        }
        return GroovyIcons.CLASS;
    }

    private boolean isRenameFileOnClassRenaming() {
        PsiFile file = this.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (groovyFile.isScript()) {
            return false;
        }
        GrTypeDefinition[] typeDefinitions = groovyFile.getTypeDefinitions();
        String name = this.getName();
        VirtualFile vFile = groovyFile.getVirtualFile();
        return vFile != null && name != null && name.equals(vFile.getNameWithoutExtension());
    }

    public PsiElement getOriginalElement() {
        return PsiImplUtil.getOriginalElement(this, this.getContainingFile());
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.addAfter must not be null");
        }
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        assert (anchor.getParent() == body);
        PsiElement nextChild = anchor.getNextSibling();
        if (nextChild == null) {
            this.add(element);
            return element;
        }
        ASTNode node = element.getNode();
        assert (node != null);
        return body.addBefore(element, nextChild);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.addBefore must not be null");
        }
        if (anchor == null) {
            this.add(element);
            return element;
        }
        GrTypeDefinitionBody body = this.getBody();
        assert (anchor.getParent() == body);
        ASTNode node = element.getNode();
        assert (node != null);
        ASTNode bodyNode = body.getNode();
        ASTNode anchorNode = anchor.getNode();
        bodyNode.addChild(node, anchorNode);
        bodyNode.addLeaf(GroovyTokenTypes.mWS, (CharSequence)" ", node);
        bodyNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        return element;
    }

    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiElement anchor;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.add must not be null");
        }
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        PsiElement lBrace = body.getLBrace();
        if (lBrace == null) {
            throw new IncorrectOperationException("No left brace");
        }
        PsiMember member = GrTypeDefinitionImpl.getAnyMember(psiElement);
        PsiElement psiElement2 = anchor = member != null ? this.getDefaultAnchor(body, member) : null;
        if (anchor == null) {
            anchor = lBrace.getNextSibling();
        }
        ASTNode bodyNode = body.getNode();
        if (anchor != null) {
            ASTNode node = anchor.getNode();
            assert (node != null);
            if (GroovyElementTypes.mSEMI.equals(node.getElementType())) {
                anchor = anchor.getNextSibling();
            }
            psiElement = body.addBefore(psiElement, anchor);
        } else {
            bodyNode.addChild(psiElement.getNode());
        }
        return psiElement;
    }

    @Nullable
    private static PsiMember getAnyMember(@Nullable PsiElement psiElement) {
        GrMember[] members;
        if (psiElement instanceof PsiMember) {
            return (PsiMember)psiElement;
        }
        if (psiElement instanceof GrVariableDeclaration && (members = ((GrVariableDeclaration)psiElement).getMembers()).length > 0) {
            return members[0];
        }
        return null;
    }

    @Nullable
    private PsiElement getDefaultAnchor(GrTypeDefinitionBody body, PsiMember member) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.getProject());
        int order = ClassElement.getMemberOrderWeight((PsiElement)member, (CodeStyleSettings)settings);
        if (order < 0) {
            return null;
        }
        PsiElement lastMember = null;
        for (PsiElement child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            int order1 = ClassElement.getMemberOrderWeight((PsiElement)GrTypeDefinitionImpl.getAnyMember(child), (CodeStyleSettings)settings);
            if (order1 < 0) continue;
            if (order1 > order) {
                PsiElement lBrace = body.getLBrace();
                if (lastMember != null) {
                    PsiElement nextSibling = lastMember.getNextSibling();
                    while (nextSibling instanceof LeafPsiElement && (nextSibling.getText().equals(",") || nextSibling.getText().equals(";"))) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    return nextSibling == null && lBrace != null ? lBrace.getNextSibling() : nextSibling;
                }
                if (lBrace != null) {
                    return lBrace.getNextSibling();
                }
            }
            lastMember = child;
        }
        return body.getRBrace();
    }

    @Override
    public <T extends GrMembersDeclaration> T addMemberDeclaration(@NotNull T decl, PsiElement anchorBefore) throws IncorrectOperationException {
        if (decl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl.addMemberDeclaration must not be null");
        }
        if (anchorBefore == null) {
            return (T)((GrMembersDeclaration)this.add(decl));
        }
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            throw new IncorrectOperationException("Type definition without a body");
        }
        ASTNode anchorNode = anchorBefore.getNode();
        ASTNode bodyNode = body.getNode();
        bodyNode.addChild(decl.getNode(), anchorNode);
        bodyNode.addLeaf(GroovyTokenTypes.mWS, (CharSequence)" ", decl.getNode());
        bodyNode.addLeaf(GroovyTokenTypes.mWS, (CharSequence)" ", anchorNode);
        return decl;
    }
}

