/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.types.GrClosureSignatureImpl;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class TypesUtil {
    @NonNls
    public static final Map<String, PsiType> ourQNameToUnboxed = new HashMap();
    private static final Map<IElementType, String> ourPrimitiveTypesToClassNames = new HashMap();
    private static final String NULL = "null";
    private static final String JAVA_MATH_BIG_DECIMAL = "java.math.BigDecimal";
    private static final String JAVA_MATH_BIG_INTEGER = "java.math.BigInteger";
    private static final Map<IElementType, String> ourOperationsToOperatorNames;
    private static final TObjectIntHashMap<String> TYPE_TO_RANK;
    private static final TIntObjectHashMap<String> RANK_TO_TYPE;

    private TypesUtil() {
    }

    @Nullable
    public static PsiType getNumericResultType(GrBinaryExpression binaryExpression, PsiType lType) {
        PsiType rType;
        GrExpression rop = binaryExpression.getRightOperand();
        PsiType psiType = rType = rop == null ? null : rop.getType();
        if (lType == null || rType == null) {
            return null;
        }
        String lCanonical = lType.getCanonicalText();
        String rCanonical = rType.getCanonicalText();
        if (TYPE_TO_RANK.containsKey((Object)lCanonical) && TYPE_TO_RANK.containsKey((Object)rCanonical)) {
            int lRank = TYPE_TO_RANK.get((Object)lCanonical);
            int rRank = TYPE_TO_RANK.get((Object)rCanonical);
            int resultRank = Math.max(lRank, rRank);
            String qName = (String)RANK_TO_TYPE.get(resultRank);
            GlobalSearchScope scope = binaryExpression.getResolveScope();
            if (qName == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)binaryExpression.getProject()).getElementFactory().createTypeByFQClassName(qName, scope);
        }
        PsiType type = TypesUtil.getOverloadedOperatorType(lType, binaryExpression.getOperationTokenType(), (GroovyPsiElement)binaryExpression, new PsiType[]{rType});
        if (type != null) {
            return type;
        }
        if (rType.equalsToText("groovy.lang.GString")) {
            PsiClassType gstringType = JavaPsiFacade.getInstance((Project)binaryExpression.getProject()).getElementFactory().createTypeByFQClassName("groovy.lang.GString", binaryExpression.getResolveScope());
            return TypesUtil.getOverloadedOperatorType(lType, binaryExpression.getOperationTokenType(), (GroovyPsiElement)binaryExpression, new PsiType[]{gstringType});
        }
        return null;
    }

    @Nullable
    public static PsiType getOverloadedOperatorType(PsiType thisType, IElementType tokenType, GroovyPsiElement place, PsiType[] argumentTypes) {
        return TypesUtil.getOverloadedOperatorType(thisType, ourOperationsToOperatorNames.get(tokenType), place, argumentTypes);
    }

    @Nullable
    public static PsiType getOverloadedOperatorType(PsiType thisType, String operatorName, GroovyPsiElement place, PsiType[] argumentTypes) {
        PsiElement element;
        GroovyResolveResult[] candidates = TypesUtil.getOverloadedOperatorCandidates(thisType, operatorName, place, argumentTypes);
        if (candidates.length == 1 && (element = candidates[0].getElement()) instanceof PsiMethod) {
            return candidates[0].getSubstitutor().substitute(((PsiMethod)element).getReturnType());
        }
        return null;
    }

    @NotNull
    public static GroovyResolveResult[] getOverloadedOperatorCandidates(PsiType thisType, IElementType tokenType, GroovyPsiElement place, PsiType[] argumentTypes) {
        GroovyResolveResult[] groovyResolveResultArray = TypesUtil.getOverloadedOperatorCandidates(thisType, ourOperationsToOperatorNames.get(tokenType), place, argumentTypes);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil.getOverloadedOperatorCandidates must not return null");
        }
        return groovyResolveResultArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static GroovyResolveResult[] getOverloadedOperatorCandidates(PsiType thisType, String operatorName, GroovyPsiElement place, PsiType[] argumentTypes) {
        GroovyResolveResult[] groovyResolveResultArray;
        if (operatorName != null) {
            PsiClassType classtype;
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass lClass;
            MethodResolverProcessor processor = new MethodResolverProcessor(operatorName, place, false, thisType, argumentTypes, PsiType.EMPTY_ARRAY);
            if (thisType instanceof PsiClassType && (lClass = (resolveResult = (classtype = (PsiClassType)thisType).resolveGenerics()).getElement()) != null) {
                lClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)resolveResult.getSubstitutor()), null, (PsiElement)place);
            }
            ResolveUtil.processNonCodeMethods(thisType, processor, place.getProject(), place, false);
            groovyResolveResultArray = processor.getCandidates();
            if (groovyResolveResultArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil.getOverloadedOperatorCandidates must not return null");
            return groovyResolveResultArray;
        }
        groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
        if (GroovyResolveResult.EMPTY_ARRAY != null) return groovyResolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil.getOverloadedOperatorCandidates must not return null");
    }

    public static boolean isAssignable(PsiType lType, PsiType rType, PsiManager manager, GlobalSearchScope scope) {
        return TypesUtil.isAssignable(lType, rType, manager, scope, true);
    }

    public static boolean isAssignable(PsiType lType, PsiType rType, PsiManager manager, GlobalSearchScope scope, boolean allowConversion) {
        if (allowConversion && TypesUtil.isAssignableByMethodCallConversion(lType, rType, manager, scope)) {
            return true;
        }
        return TypesUtil._isAssignable(lType, rType, manager, scope);
    }

    public static boolean isAssignable(PsiType lType, PsiType rType, GroovyPsiElement context) {
        return TypesUtil.isAssignableByMethodCallConversion(lType, rType, context) || TypesUtil._isAssignable(lType, rType, context.getManager(), context.getResolveScope());
    }

    private static boolean _isAssignable(PsiType lType, PsiType rType, PsiManager manager, GlobalSearchScope scope) {
        if (lType == null || rType == null) {
            return false;
        }
        if (TypesUtil.isNumericType(lType)) {
            return TypesUtil.isNumericType(rType) || rType.equals(PsiType.NULL);
        }
        if (lType.equalsToText("java.lang.String")) {
            return true;
        }
        rType = TypesUtil.boxPrimitiveType(rType, manager, scope);
        lType = TypesUtil.boxPrimitiveType(lType, manager, scope);
        return lType.isAssignableFrom(rType);
    }

    public static boolean isAssignableByMethodCallConversion(PsiType lType, PsiType rType, GroovyPsiElement context) {
        if (lType == null || rType == null) {
            return false;
        }
        if (TypesUtil.isAssignableByMethodCallConversion(lType, rType, context.getManager(), context.getResolveScope())) {
            return true;
        }
        for (GrTypeConverter converter : (GrTypeConverter[])GrTypeConverter.EP_NAME.getExtensions()) {
            Boolean result = converter.isConvertible(lType, rType, context);
            if (result == null) continue;
            return result;
        }
        return false;
    }

    public static boolean isAssignableByMethodCallConversion(PsiType lType, PsiType rType, PsiManager manager, GlobalSearchScope scope) {
        PsiClass javaLangString;
        GrTupleType tuple;
        if (lType == null || rType == null) {
            return false;
        }
        if (rType instanceof GrTupleType && (tuple = (GrTupleType)rType).getComponentTypes().length == 0 && (lType instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.List") || InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.Set"))) {
            return true;
        }
        if (rType.equalsToText("groovy.lang.GString") && (javaLangString = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.String", scope)) != null && TypesUtil.isAssignable(lType, (PsiType)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createType(javaLangString), manager, scope)) {
            return true;
        }
        if (TypesUtil.isNumericType(lType) && TypesUtil.isNumericType(rType)) {
            if ((lType = TypesUtil.unboxPrimitiveTypeWrapper(lType)).equalsToText(JAVA_MATH_BIG_DECIMAL)) {
                lType = PsiType.DOUBLE;
            }
            if ((rType = TypesUtil.unboxPrimitiveTypeWrapper(rType)).equalsToText(JAVA_MATH_BIG_DECIMAL)) {
                rType = PsiType.DOUBLE;
            }
        } else {
            rType = TypesUtil.boxPrimitiveType(rType, manager, scope);
            lType = TypesUtil.boxPrimitiveType(lType, manager, scope);
        }
        return TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType);
    }

    public static boolean isNumericType(PsiType type) {
        if (type instanceof PsiClassType) {
            return TYPE_TO_RANK.contains((Object)type.getCanonicalText());
        }
        return type instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type);
    }

    public static PsiType unboxPrimitiveTypeWraperAndEraseGenerics(PsiType result) {
        return TypeConversionUtil.erasure((PsiType)TypesUtil.unboxPrimitiveTypeWrapper(result));
    }

    public static PsiType unboxPrimitiveTypeWrapper(PsiType type) {
        PsiType unboxed;
        if (type instanceof PsiClassType && (unboxed = ourQNameToUnboxed.get(type.getCanonicalText())) != null) {
            type = unboxed;
        }
        return type;
    }

    public static PsiType boxPrimitiveType(PsiType result, PsiManager manager, GlobalSearchScope resolveScope) {
        PsiPrimitiveType primitive;
        String boxedTypeName;
        if (result instanceof PsiPrimitiveType && result != PsiType.VOID && (boxedTypeName = (primitive = (PsiPrimitiveType)result).getBoxedTypeName()) != null) {
            return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName(boxedTypeName, resolveScope);
        }
        return result;
    }

    @Nullable
    public static PsiType getTypeForIncOrDecExpression(GrUnaryExpression expr) {
        PsiType opType;
        GrExpression op = expr.getOperand();
        if (op != null && (opType = op.getType()) != null) {
            PsiType overloaded = TypesUtil.getOverloadedOperatorType(opType, expr.getOperationTokenType(), (GroovyPsiElement)expr, PsiType.EMPTY_ARRAY);
            if (overloaded != null) {
                return overloaded;
            }
            if (TypesUtil.isNumericType(opType)) {
                return opType;
            }
        }
        return null;
    }

    public static PsiClassType createType(String fqName, PsiElement context) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        return facade.getElementFactory().createTypeByFQClassName(fqName, context.getResolveScope());
    }

    public static PsiClassType getJavaLangObject(PsiElement context) {
        return PsiType.getJavaLangObject((PsiManager)context.getManager(), (GlobalSearchScope)context.getResolveScope());
    }

    @Nullable
    public static PsiType getLeastUpperBound(@NotNull PsiType type1, @NotNull PsiType type2, PsiManager manager) {
        if (type1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil.getLeastUpperBound must not be null");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil.getLeastUpperBound must not be null");
        }
        if (type1 instanceof GrTupleType && type2 instanceof GrTupleType) {
            GrTupleType tuple1 = (GrTupleType)type1;
            GrTupleType tuple2 = (GrTupleType)type2;
            PsiType[] components1 = tuple1.getComponentTypes();
            PsiType[] components2 = tuple2.getComponentTypes();
            PsiType[] components3 = new PsiType[Math.min(components1.length, components2.length)];
            for (int i = 0; i < components3.length; ++i) {
                PsiType c1 = components1[i];
                PsiType c2 = components2[i];
                components3[i] = c1 == null || c2 == null ? null : TypesUtil.getLeastUpperBound(c1, c2, manager);
            }
            return new GrTupleType(components3, JavaPsiFacade.getInstance((Project)manager.getProject()), tuple1.getScope().intersectWith(tuple2.getResolveScope()));
        }
        if (type1 instanceof GrClosureType && type2 instanceof GrClosureType) {
            GrClosureSignature signature;
            GrClosureParameter[] parameters2;
            GrClosureType clType1 = (GrClosureType)type1;
            GrClosureType clType2 = (GrClosureType)type2;
            GrClosureSignature signature1 = clType1.getSignature();
            GrClosureSignature signature2 = clType2.getSignature();
            GrClosureParameter[] parameters1 = signature1.getParameters();
            if (parameters1.length == (parameters2 = signature2.getParameters()).length && (signature = GrClosureSignatureImpl.getLeastUpperBound(signature1, signature2, manager)) != null) {
                GlobalSearchScope scope = clType1.getResolveScope().intersectWith(clType2.getResolveScope());
                LanguageLevel languageLevel = (LanguageLevel)ComparatorUtil.max((Comparable)clType1.getLanguageLevel(), (Comparable)clType2.getLanguageLevel());
                return GrClosureType.create(signature, manager, scope, languageLevel);
            }
        } else {
            if ("groovy.lang.GString".equals(type1.getCanonicalText()) && "java.lang.String".equals(type2.getInternalCanonicalText())) {
                return type2;
            }
            if ("groovy.lang.GString".equals(type2.getCanonicalText()) && "java.lang.String".equals(type1.getInternalCanonicalText())) {
                return type1;
            }
        }
        return GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)manager);
    }

    @Nullable
    public static PsiType getPsiType(PsiElement context, IElementType elemType) {
        if (elemType == GroovyTokenTypes.kNULL) {
            return PsiType.NULL;
        }
        String typeName = TypesUtil.getPsiTypeName(elemType);
        if (typeName != null) {
            return JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeByFQClassName(typeName, context.getResolveScope());
        }
        return null;
    }

    @Nullable
    public static String getPsiTypeName(IElementType elemType) {
        return ourPrimitiveTypesToClassNames.get(elemType);
    }

    static {
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mSTRING_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mGSTRING_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mREGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_INT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_LONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_FLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_DOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_INT, JAVA_MATH_BIG_INTEGER);
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_DECIMAL, JAVA_MATH_BIG_DECIMAL);
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFALSE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kTRUE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kNULL, NULL);
        ourOperationsToOperatorNames = new HashMap();
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mPLUS, "plus");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mMINUS, "minus");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBAND, "and");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBOR, "or");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBXOR, "xor");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mDIV, "div");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mMOD, "mod");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mSTAR, "multiply");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mDEC, "previous");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mINC, "next");
        TYPE_TO_RANK = new TObjectIntHashMap();
        TYPE_TO_RANK.put((Object)"java.lang.Byte", 1);
        TYPE_TO_RANK.put((Object)"java.lang.Short", 2);
        TYPE_TO_RANK.put((Object)"java.lang.Character", 2);
        TYPE_TO_RANK.put((Object)"java.lang.Integer", 3);
        TYPE_TO_RANK.put((Object)"java.lang.Long", 4);
        TYPE_TO_RANK.put((Object)JAVA_MATH_BIG_INTEGER, 5);
        TYPE_TO_RANK.put((Object)JAVA_MATH_BIG_DECIMAL, 6);
        TYPE_TO_RANK.put((Object)"java.lang.Float", 7);
        TYPE_TO_RANK.put((Object)"java.lang.Double", 8);
        TYPE_TO_RANK.put((Object)"java.lang.Number", 9);
        ourQNameToUnboxed.put("java.lang.Boolean", PsiType.BOOLEAN);
        ourQNameToUnboxed.put("java.lang.Byte", PsiType.BYTE);
        ourQNameToUnboxed.put("java.lang.Character", PsiType.CHAR);
        ourQNameToUnboxed.put("java.lang.Short", PsiType.SHORT);
        ourQNameToUnboxed.put("java.lang.Integer", PsiType.INT);
        ourQNameToUnboxed.put("java.lang.Long", PsiType.LONG);
        ourQNameToUnboxed.put("java.lang.Float", PsiType.FLOAT);
        ourQNameToUnboxed.put("java.lang.Double", PsiType.DOUBLE);
        RANK_TO_TYPE = new TIntObjectHashMap();
        RANK_TO_TYPE.put(1, (Object)"java.lang.Integer");
        RANK_TO_TYPE.put(2, (Object)"java.lang.Integer");
        RANK_TO_TYPE.put(3, (Object)"java.lang.Integer");
        RANK_TO_TYPE.put(4, (Object)"java.lang.Long");
        RANK_TO_TYPE.put(5, (Object)JAVA_MATH_BIG_INTEGER);
        RANK_TO_TYPE.put(6, (Object)JAVA_MATH_BIG_DECIMAL);
        RANK_TO_TYPE.put(7, (Object)"java.lang.Double");
        RANK_TO_TYPE.put(8, (Object)"java.lang.Double");
        RANK_TO_TYPE.put(9, (Object)"java.lang.Number");
    }
}

