/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyParameterInfoHandler
implements ParameterInfoHandler<GroovyPsiElement, GroovyResolveResult> {
    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        List elements = JavaCompletionUtil.getAllPsiElements((LookupElement)item);
        if (elements != null) {
            ArrayList<GroovyResolveResultImpl> methods = new ArrayList<GroovyResolveResultImpl>();
            for (PsiElement element : elements) {
                if (!(element instanceof PsiMethod)) continue;
                methods.add(new GroovyResolveResultImpl(element, true));
            }
            return ArrayUtil.toObjectArray(methods);
        }
        return null;
    }

    public Object[] getParametersForDocumentation(GroovyResolveResult resolveResult, ParameterInfoContext context) {
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public GroovyPsiElement findElementForParameterInfo(CreateParameterInfoContext context) {
        return GroovyParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    public GroovyPsiElement findElementForUpdatingParameterInfo(UpdateParameterInfoContext context) {
        return GroovyParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    @Nullable
    private static GroovyPsiElement findAnchorElement(int offset, PsiFile file) {
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        GroovyPsiElement argList = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, GrArgumentList.class);
        if (argList != null) {
            return argList;
        }
        GrCall call = (GrCall)PsiTreeUtil.getParentOfType((PsiElement)element, GrCall.class);
        if (call != null) {
            argList = call.getArgumentList();
            if (argList != null && argList.getTextRange().contains(element.getTextRange().getStartOffset())) {
                return argList;
            }
        } else {
            offset = CharArrayUtil.shiftBackward((CharSequence)file.getText(), (int)offset, (String)"\n\t ");
            if (offset <= 0) {
                return null;
            }
            element = file.findElementAt(offset);
            if (element != null && element.getParent() instanceof GrReferenceExpression) {
                return (GroovyPsiElement)element.getParent();
            }
        }
        return null;
    }

    public void showParameterInfo(@NotNull GroovyPsiElement place, CreateParameterInfoContext context) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyParameterInfoHandler.showParameterInfo must not be null");
        }
        Object[] variants = ResolveUtil.getMethodVariants(place);
        List namedElements = ContainerUtil.findAll((Object[])variants, (Condition)new Condition<GroovyResolveResult>(){

            public boolean value(GroovyResolveResult groovyResolveResult) {
                return groovyResolveResult.getElement() instanceof PsiNamedElement;
            }
        });
        context.setItemsToShow(ArrayUtil.toObjectArray((Collection)namedElements));
        context.showHint((PsiElement)place, place.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public void updateParameterInfo(@NotNull GroovyPsiElement place, UpdateParameterInfoContext context) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyParameterInfoHandler.updateParameterInfo must not be null");
        }
        int offset = context.getEditor().getCaretModel().getOffset();
        offset = CharArrayUtil.shiftForward((CharSequence)context.getEditor().getDocument().getText(), (int)offset, (String)" \t\n");
        int currIndex = GroovyParameterInfoHandler.getCurrentParameterIndex(place, offset);
        context.setCurrentParameter(currIndex);
        Object[] objects = context.getObjectsToView();
        block0: for (int i = 0; i < objects.length; ++i) {
            PsiType type;
            GroovyResolveResult resolveResult = (GroovyResolveResult)objects[i];
            PsiNamedElement namedElement = (PsiNamedElement)resolveResult.getElement();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            assert (namedElement != null);
            if (!namedElement.isValid()) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            PsiType[] argTypes = null;
            Object[] parameterTypes = null;
            if (namedElement instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)namedElement;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                parameterTypes = new PsiType[parameters.length];
                for (int j = 0; j < parameters.length; ++j) {
                    parameterTypes[j] = parameters[j].getType();
                }
                if (resolveResult.getCurrentFileResolveContext() instanceof GrMethodCallExpression) {
                    parameterTypes = (PsiType[])ArrayUtil.remove((Object[])parameterTypes, (int)0);
                }
                argTypes = PsiUtil.getArgumentTypes(place, false);
            } else if (namedElement instanceof GrVariable && (type = ((GrVariable)namedElement).getTypeGroovy()) instanceof GrClosureType) {
                argTypes = PsiUtil.getArgumentTypes(place, false);
                parameterTypes = ((GrClosureType)type).getClosureParameterTypes();
            }
            if (argTypes == null) continue;
            if (parameterTypes.length <= currIndex) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            for (int j = 0; j < currIndex; ++j) {
                PsiType argType = argTypes[j];
                PsiType paramType = substitutor.substitute(parameterTypes[j]);
                if (TypesUtil.isAssignable(paramType, argType, place)) continue;
                context.setUIComponentEnabled(i, false);
                break block0;
            }
            context.setUIComponentEnabled(i, true);
        }
    }

    private static int getCurrentParameterIndex(GroovyPsiElement place, int offset) {
        if (place instanceof GrArgumentList) {
            GrExpression[] exprs;
            GrNamedArgument[] namedArguments;
            GrArgumentList list = (GrArgumentList)place;
            for (GrNamedArgument namedArgument : namedArguments = list.getNamedArguments()) {
                if (!namedArgument.getTextRange().contains(offset)) continue;
                return 0;
            }
            int idx = namedArguments.length > 0 ? 1 : 0;
            for (GrExpression expr : exprs = list.getExpressionArguments()) {
                if (expr.getTextRange().contains(offset)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(GroovyResolveResult resolveResult, ParameterInfoUIContext context) {
        PsiElement parent;
        PsiType type;
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        PsiNamedElement element = (PsiNamedElement)resolveResult.getElement();
        if (element == null || !element.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        StringBuffer buffer = new StringBuffer();
        if (element instanceof PsiMethod) {
            int numParams;
            PsiMethod method = (PsiMethod)element;
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                PsiType returnType;
                if (!method.isConstructor() && (returnType = method.getReturnType()) != null) {
                    buffer.append(returnType.getPresentableText());
                    buffer.append(" ");
                }
                buffer.append(element.getName());
                buffer.append("(");
            }
            int currentParameter = context.getCurrentParameterIndex();
            Object[] parms = method.getParameterList().getParameters();
            if (resolveResult.getCurrentFileResolveContext() instanceof GrMethodCallExpression) {
                parms = (PsiParameter[])ArrayUtil.remove((Object[])parms, (int)0);
            }
            if ((numParams = parms.length) > 0) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (int j = 0; j < numParams; ++j) {
                    Object parm = parms[j];
                    int startOffset = buffer.length();
                    GroovyParameterInfoHandler.appendParameterText((PsiParameter)parm, substitutor, buffer);
                    int endOffset = buffer.length();
                    if (j < numParams - 1) {
                        buffer.append(", ");
                    }
                    if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !parm.isVarArgs() || currentParameter < numParams)) continue;
                    highlightStartOffset = startOffset;
                    highlightEndOffset = endOffset;
                }
            } else {
                buffer.append("no parameters");
            }
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(")");
            }
        } else if (element instanceof PsiClass) {
            buffer.append("no parameters");
        } else if (element instanceof GrVariable && (type = (parent = context.getParameterOwner().getParent()) instanceof GrMethodCallExpression ? ((GrMethodCallExpression)parent).getInvokedExpression().getType() : ((GrVariable)element).getTypeGroovy()) instanceof GrClosureType) {
            GrClosureParameter[] parameters = ((GrClosureType)type).getSignature().getParameters();
            if (parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    String name = parameters[i].getName();
                    PsiType psiType = parameters[i].getType();
                    if (name == null) {
                        buffer.append(psiType == null ? "null" : psiType.getPresentableText());
                        continue;
                    }
                    String typeText = psiType == null ? "def" : psiType.getPresentableText();
                    buffer.append(typeText).append(' ').append(name);
                    GrExpression initializer = parameters[i].getDefaultInitializer();
                    if (initializer == null) continue;
                    buffer.append(" = ").append(initializer.getText());
                }
            } else {
                buffer.append("no parameters");
            }
        }
        boolean isDeprecated = resolveResult instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)resolveResult).isDeprecated();
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), isDeprecated, false, context.getDefaultParameterColor());
    }

    private static void appendParameterText(PsiParameter parm, PsiSubstitutor substitutor, StringBuffer buffer) {
        if (parm instanceof GrParameter) {
            buffer.append(GroovyPresentationUtil.getParameterPresentation((GrParameter)parm, substitutor));
            GrExpression initializer = ((GrParameter)parm).getDefaultInitializer();
            if (initializer != null) {
                buffer.append(" = ").append(initializer.getText());
            }
        } else {
            PsiType t = parm.getType();
            PsiType paramType = substitutor.substitute(t);
            buffer.append(paramType.getPresentableText());
            String name = parm.getName();
            if (name != null) {
                buffer.append(" ");
                buffer.append(name);
            }
        }
    }
}

