/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GrMethodBodyFixer
implements GrFixer {
    @Override
    public void apply(Editor editor, GroovySmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof GrMethod)) {
            return;
        }
        GrMethod method = (GrMethod)psiElement;
        if (method.getContainingClass().isInterface() || method.hasModifierProperty("abstract")) {
            return;
        }
        GrOpenBlock body = method.getBlock();
        Document doc = editor.getDocument();
        if (body != null) {
            GrStatement[] statements;
            String bodyText = body.getText();
            if (!bodyText.startsWith("{") || (statements = body.getStatements()).length > 0) {
                // empty if block
            }
            return;
        }
        int endOffset = method.getTextRange().getEndOffset();
        if (StringUtil.endsWithChar((CharSequence)method.getText(), (char)';')) {
            doc.deleteString(endOffset - 1, endOffset);
            --endOffset;
        }
        doc.insertString(endOffset, (CharSequence)"{\n}");
    }
}

