/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.RemoveParenthesesFromMethodPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class RemoveParenthesesFromMethodCallIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        RemoveParenthesesFromMethodPredicate removeParenthesesFromMethodPredicate = new RemoveParenthesesFromMethodPredicate();
        if (removeParenthesesFromMethodPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention.getElementPredicate must not return null");
        }
        return removeParenthesesFromMethodPredicate;
    }

    @Override
    protected boolean isStopElement(PsiElement element) {
        return element instanceof GrStatementOwner;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        GrExpression[] arguments;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/RemoveParenthesesFromMethodCallIntention.processIntention must not be null");
        }
        GrMethodCallExpression expression = (GrMethodCallExpression)element;
        StringBuilder newStatementText = new StringBuilder();
        newStatementText.append(expression.getInvokedExpression().getText());
        GrArgumentList argumentList = expression.getArgumentList();
        if (argumentList != null && (arguments = argumentList.getExpressionArguments()).length > 0) {
            newStatementText.append(" ");
            newStatementText.append(arguments[0].getText());
            for (int i = 1; i < arguments.length; ++i) {
                newStatementText.append(",");
                GrExpression argument = arguments[i];
                newStatementText.append(argument.getText());
            }
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrStatement newStatement = factory.createStatementFromText(newStatementText.toString());
        expression.replaceWithStatement(newStatement);
    }
}

