/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.formatter.GroovyBlock;

public class GroovyFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        ASTNode node = element.getNode();
        assert (node != null);
        PsiFile containingFile = element.getContainingFile().getViewProvider().getPsi(GroovyFileType.GROOVY_LANGUAGE);
        assert (containingFile != null) : element.getContainingFile();
        ASTNode astNode = containingFile.getNode();
        assert (astNode != null);
        GroovyBlock block = new GroovyBlock(astNode, null, Indent.getAbsoluteNoneIndent(), null, settings);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)containingFile, (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyFormattingModelBuilder.createModel must not return null");
        }
        return formattingModel;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }
}

