/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Field;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;

public class MultipleCheckboxOptionsPanel
extends JPanel {
    private final BaseInspection owner;

    public MultipleCheckboxOptionsPanel(BaseInspection owner) {
        super(new GridBagLayout());
        this.owner = owner;
    }

    public void addCheckbox(String label, @NonNls String property) {
        boolean selected = MultipleCheckboxOptionsPanel.getPropertyValue(this.owner, property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        ButtonModel model = checkBox.getModel();
        CheckboxChangeListener changeListener = new CheckboxChangeListener(this.owner, property, model);
        model.addChangeListener(changeListener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        Component[] components = this.getComponents();
        this.removeAll();
        for (Component component : components) {
            this.add(component, constraints);
            ++constraints.gridy;
        }
        constraints.weighty = 1.0;
        this.add((Component)checkBox, constraints);
    }

    private static boolean getPropertyValue(BaseInspection owner, String property) {
        try {
            Class<?> aClass = ((Object)((Object)owner)).getClass();
            Field field = aClass.getField(property);
            return field.getBoolean((Object)owner);
        }
        catch (IllegalAccessException ignored) {
            return false;
        }
        catch (NoSuchFieldException ignored) {
            return false;
        }
    }

    private static class CheckboxChangeListener
    implements ChangeListener {
        private final BaseInspection owner;
        private final String property;
        private final ButtonModel model;

        CheckboxChangeListener(BaseInspection owner, String property, ButtonModel model) {
            this.owner = owner;
            this.property = property;
            this.model = model;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CheckboxChangeListener.setPropertyValue(this.owner, this.property, this.model.isSelected());
        }

        private static void setPropertyValue(BaseInspection owner, String property, boolean selected) {
            try {
                Class<?> aClass = ((Object)((Object)owner)).getClass();
                Field field = aClass.getField(property);
                field.setBoolean((Object)owner, selected);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }
}

