/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.naming.RenameFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GroovyAnnotationNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        if ("Annotation naming convention" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection.getDisplayName must not return null");
        }
        return "Annotation naming convention";
    }

    @Override
    protected GroovyFix buildFix(PsiElement location) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return "Annotation name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            return "Annotation name '#ref' is too long";
        }
        String string = "Annotation name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection.buildErrorString must not return null");
        return string2;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitTypeDefinition(GrTypeDefinition grTypeDefinition) {
            super.visitTypeDefinition(grTypeDefinition);
            if (!(grTypeDefinition instanceof GrAnnotationTypeDefinition)) {
                return;
            }
            GrAnnotationTypeDefinition aClass = (GrAnnotationTypeDefinition)grTypeDefinition;
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (GroovyAnnotationNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }
    }
}

