/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntAllTasksContainerImpl;
import com.intellij.lang.ant.psi.impl.AntAntImpl;
import com.intellij.lang.ant.psi.impl.AntBuildNumberImpl;
import com.intellij.lang.ant.psi.impl.AntCallImpl;
import com.intellij.lang.ant.psi.impl.AntCommentImpl;
import com.intellij.lang.ant.psi.impl.AntDirSetImpl;
import com.intellij.lang.ant.psi.impl.AntEntityRefImpl;
import com.intellij.lang.ant.psi.impl.AntFileListImpl;
import com.intellij.lang.ant.psi.impl.AntFileSetImpl;
import com.intellij.lang.ant.psi.impl.AntImportImpl;
import com.intellij.lang.ant.psi.impl.AntMacroDefImpl;
import com.intellij.lang.ant.psi.impl.AntPathImpl;
import com.intellij.lang.ant.psi.impl.AntPresetDefImpl;
import com.intellij.lang.ant.psi.impl.AntPropertyImpl;
import com.intellij.lang.ant.psi.impl.AntScriptDefImpl;
import com.intellij.lang.ant.psi.impl.AntStructuredElementImpl;
import com.intellij.lang.ant.psi.impl.AntTargetImpl;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.impl.AntTimestampFormatImpl;
import com.intellij.lang.ant.psi.impl.AntTypeDefImpl;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.psi.PsiLock;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Available;
import org.apache.tools.ant.taskdefs.Basename;
import org.apache.tools.ant.taskdefs.BuildNumber;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Checksum;
import org.apache.tools.ant.taskdefs.ConditionTask;
import org.apache.tools.ant.taskdefs.Dirname;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.ImportTask;
import org.apache.tools.ant.taskdefs.Input;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Length;
import org.apache.tools.ant.taskdefs.LoadFile;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.ManifestClassPath;
import org.apache.tools.ant.taskdefs.Parallel;
import org.apache.tools.ant.taskdefs.PathConvert;
import org.apache.tools.ant.taskdefs.PreSetDef;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.apache.tools.ant.taskdefs.TempFile;
import org.apache.tools.ant.taskdefs.Tstamp;
import org.apache.tools.ant.taskdefs.Typedef;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.taskdefs.WhichResource;
import org.apache.tools.ant.taskdefs.optional.extension.JarLibResolveTask;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Counter;
import org.apache.tools.ant.taskdefs.optional.script.ScriptDef;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AntElementFactory {
    @NonNls
    private static final String RESULT_PROPERTY = "resultproperty";
    @NonNls
    private static final String TOTAL_PROPERTY = "totalproperty";
    private static Map<String, AntElementCreator> ourAntTypeToKnownAntElementCreatorMap = null;
    private static final String[] PROPERTY_CLASSES = new String[]{Available.class.getName(), ConditionTask.class.getName(), UpToDate.class.getName(), Dirname.class.getName(), Basename.class.getName(), LoadFile.class.getName(), TempFile.class.getName(), PathConvert.class.getName(), Length.class.getName(), WhichResource.class.getName(), JarLibResolveTask.class.getName(), P4Counter.class.getName(), ManifestClassPath.class.getName()};
    private static final String[] ALL_TASKS_CONTAINER_CLASSES = new String[]{MacroDef.NestedSequential.class.getName(), Sequential.class.getName(), Parallel.class.getName()};

    private AntElementFactory() {
    }

    @Nullable
    public static AntElement createAntElement(AntStructuredElement parent, XmlElement element) {
        String className;
        AntElementFactory.instantiate();
        if (element instanceof XmlComment) {
            return new AntCommentImpl(parent, element);
        }
        if (element instanceof XmlEntityRef) {
            return new AntEntityRefImpl(parent, element);
        }
        if (!(element instanceof XmlTag)) {
            return null;
        }
        XmlTag tag = (XmlTag)element;
        Object typeDef = null;
        String typeName = tag.getLocalName();
        String nsPrefix = tag.getNamespacePrefix();
        if (nsPrefix.length() == 0) {
            if (typeName.equals("javadoc2")) {
                typeName = "javadoc2";
            }
            if (typeName.equals("unwar") || typeName.equals("unjar")) {
                typeName = "unzip";
            }
        }
        AntTypeId id = new AntTypeId(typeName, nsPrefix);
        AntFile file = parent.getAntFile();
        AntTypeDefinition parentDef = parent.getTypeDefinition();
        if (parentDef != null && (className = parentDef.getNestedClassName(id)) != null && file != null) {
            typeDef = file.getBaseTypeDefinition(className);
        }
        if (file != null) {
            if (typeDef == null) {
                typeDef = file.getBaseTypeDefinition(AntMacroDefImpl.createMacroClassName(typeName));
            }
            if (typeDef == null) {
                typeDef = file.getBaseTypeDefinition(AntPresetDefImpl.createPresetDefClassName(typeName));
            }
            if (typeDef == null) {
                AntProject project = file.getAntProject();
                AntTypeDefinition projectDef = project != null ? project.getTypeDefinition() : null;
                for (AntTypeDefinition def : file.getBaseTypeDefinitions()) {
                    boolean isRegisteredWithinProject;
                    if (!id.equals(def.getTypeId()) || projectDef != null && !(isRegisteredWithinProject = def.getClassName().equals(projectDef.getNestedClassName(def.getTypeId())))) continue;
                    typeDef = def;
                    break;
                }
            }
        }
        boolean importedType = false;
        if (typeDef == null) {
            AntProject project = parent.getAntProject();
            block1: for (AntFile imported : project.getImportedFiles()) {
                AntProject importedProject = imported.getAntProject();
                if (project.equals(importedProject)) continue;
                importedProject.getChildren();
                for (AntTypeDefinition def : imported.getBaseTypeDefinitions()) {
                    if (!id.equals(def.getTypeId())) continue;
                    importedType = true;
                    typeDef = def;
                    continue block1;
                }
            }
        }
        AntStructuredElementImpl result = null;
        if (typeDef != null) {
            AntElementCreator antElementCreator = ourAntTypeToKnownAntElementCreatorMap.get(typeDef.getClassName());
            if (antElementCreator != null) {
                result = (AntStructuredElementImpl)antElementCreator.create(parent, tag);
            } else if (typeDef.isTask()) {
                result = typeDef.isProperty() ? new AntPropertyImpl(parent, tag, (AntTypeDefinition)typeDef) : (typeDef.isAllTaskContainer() ? new AntAllTasksContainerImpl(parent, tag, (AntTypeDefinition)typeDef) : new AntTaskImpl(parent, tag, (AntTypeDefinition)typeDef));
            }
        }
        if (result == null) {
            result = "format".equals(tag.getName()) ? new AntTimestampFormatImpl(parent, tag, (AntTypeDefinition)typeDef) : new AntStructuredElementImpl((AntElement)parent, tag, (AntTypeDefinition)typeDef);
        }
        result.setImportedTypeDefinition(importedType);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instantiate() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (ourAntTypeToKnownAntElementCreatorMap == null) {
                ourAntTypeToKnownAntElementCreatorMap = new HashMap();
                AntElementCreator targetCreator = new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntTargetImpl(parent, tag);
                    }
                };
                ourAntTypeToKnownAntElementCreatorMap.put(Target.class.getName(), targetCreator);
                ourAntTypeToKnownAntElementCreatorMap.put(Ant.TargetElement.class.getName(), targetCreator);
                ourAntTypeToKnownAntElementCreatorMap.put(Property.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntPropertyImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(Property.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Tstamp.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntPropertyImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(Tstamp.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Checksum.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        AntTypeDefinition checksumDef = parent.getAntFile().getBaseTypeDefinition(Checksum.class.getName());
                        if (tag.getAttributeValue(AntElementFactory.TOTAL_PROPERTY) != null) {
                            return new AntPropertyImpl(parent, tag, checksumDef, AntElementFactory.TOTAL_PROPERTY);
                        }
                        return new AntPropertyImpl(parent, tag, checksumDef, "property");
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(ExecTask.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        AntTypeDefinition execDef = parent.getAntFile().getBaseTypeDefinition(ExecTask.class.getName());
                        if (tag.getAttributeValue(AntElementFactory.RESULT_PROPERTY) != null) {
                            return new AntPropertyImpl(parent, tag, execDef, AntElementFactory.RESULT_PROPERTY);
                        }
                        return new AntPropertyImpl(parent, tag, execDef, "outputproperty");
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Java.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        AntTypeDefinition execDef = parent.getAntFile().getBaseTypeDefinition(Java.class.getName());
                        return new AntPropertyImpl(parent, tag, execDef, AntElementFactory.RESULT_PROPERTY);
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Input.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        AntTypeDefinition execDef = parent.getAntFile().getBaseTypeDefinition(Input.class.getName());
                        return new AntPropertyImpl(parent, tag, execDef, "addproperty");
                    }
                });
                for (String clazz : PROPERTY_CLASSES) {
                    AntElementFactory.addPropertyCreator(clazz);
                }
                for (String clazz : ALL_TASKS_CONTAINER_CLASSES) {
                    AntElementFactory.addAllTasksContainerCreator(clazz);
                }
                ourAntTypeToKnownAntElementCreatorMap.put(CallTarget.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntCallImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(CallTarget.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Taskdef.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntTypeDefImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(Taskdef.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Typedef.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntTypeDefImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(Typedef.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(MacroDef.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntMacroDefImpl((AntStructuredElement)parent, tag, parent.getAntFile().getBaseTypeDefinition(MacroDef.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(PreSetDef.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntPresetDefImpl((AntStructuredElement)parent, tag, parent.getAntFile().getBaseTypeDefinition(PreSetDef.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(ScriptDef.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntScriptDefImpl((AntStructuredElement)parent, tag, parent.getAntFile().getBaseTypeDefinition(ScriptDef.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(ImportTask.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntImportImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(ImportTask.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Ant.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntAntImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(Ant.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(BuildNumber.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntBuildNumberImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(BuildNumber.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(DirSet.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntDirSetImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(DirSet.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(FileList.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntFileListImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(FileList.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(FileSet.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntFileSetImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(FileSet.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Path.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntPathImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(Path.class.getName()));
                    }
                });
                ourAntTypeToKnownAntElementCreatorMap.put(Path.PathElement.class.getName(), new AntElementCreator(){

                    @Override
                    public AntStructuredElement create(AntElement parent, XmlTag tag) {
                        return new AntPathImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(Path.PathElement.class.getName()));
                    }
                });
            }
        }
    }

    private static void addPropertyCreator(final String className) {
        ourAntTypeToKnownAntElementCreatorMap.put(className, new AntElementCreator(){

            @Override
            public AntStructuredElement create(AntElement parent, XmlTag tag) {
                return new AntPropertyImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(className), "property");
            }
        });
    }

    private static void addAllTasksContainerCreator(final String className) {
        ourAntTypeToKnownAntElementCreatorMap.put(className, new AntElementCreator(){

            @Override
            public AntStructuredElement create(AntElement parent, XmlTag tag) {
                return new AntAllTasksContainerImpl(parent, tag, parent.getAntFile().getBaseTypeDefinition(className));
            }
        });
    }

    private static interface AntElementCreator {
        public AntStructuredElement create(AntElement var1, XmlTag var2);
    }
}

