/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.impl.configuration.ReorderableListToolbar;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ReorderableListController;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AnActionListEditor<T>
extends JPanel {
    private final Form<T> myForm = new Form();
    private final ArrayList<T> myRemoved = new ArrayList();
    private final ArrayList<T> myAdded = new ArrayList();

    public AnActionListEditor() {
        super(new BorderLayout());
        this.add((Component)((Form)this.myForm).myWholePanel, "Center");
    }

    public void addAddAction(Factory<T> newItemFactory) {
        ReorderableListController.AddActionDescription description = this.myForm.getListActionsBuilder().addAddAction(AntBundle.message("add.action.name", new Object[0]), newItemFactory, true);
        description.addPostHandler(new ReorderableListController.ActionNotification<T>(){

            public void afterActionPerformed(T value) {
                AnActionListEditor.this.myAdded.add(value);
            }
        });
        description.setShowText(true);
    }

    public void addRemoveButtonForAnt(Condition<T> removeCondition, String actionName) {
        final ReorderableListController.RemoveActionDescription description = this.myForm.getListActionsBuilder().addRemoveAction(actionName);
        description.addPostHandler(new ReorderableListController.ActionNotification<List<T>>(){

            public void afterActionPerformed(List<T> list) {
                for (Object item : list) {
                    if (AnActionListEditor.this.myAdded.contains(item)) {
                        AnActionListEditor.this.myAdded.remove(item);
                        continue;
                    }
                    AnActionListEditor.this.myRemoved.add(item);
                }
            }
        });
        description.setEnableCondition(removeCondition);
        description.setConfirmation(new Condition<List<T>>(){

            public boolean value(List<T> list) {
                if (list.size() == 1) {
                    return Messages.showOkCancelDialog((Component)description.getList(), (String)AntBundle.message("delete.selected.ant.configuration.confirmation.text", new Object[0]), (String)ExecutionBundle.message((String)"delete.confirmation.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
                }
                return Messages.showOkCancelDialog((Component)description.getList(), (String)AntBundle.message("delete.selected.ant.configurations.confirmation.text", new Object[0]), (String)ExecutionBundle.message((String)"delete.confirmation.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
            }
        });
        description.setShowText(true);
    }

    public T getSelectedItem() {
        return (T)((Form)this.myForm).myList.getSelectedValue();
    }

    public void setSelection(T item) {
        this.myForm.select(item);
    }

    public JList getList() {
        return ((Form)this.myForm).myList;
    }

    public ArrayList<T> getAdded() {
        return this.myAdded;
    }

    public ArrayList<T> getRemoved() {
        return this.myRemoved;
    }

    public void setItems(Collection<T> items) {
        DefaultListModel model = ((Form)this.myForm).getListModel();
        model.removeAllElements();
        for (T item : items) {
            model.addElement(item);
        }
        ListScrollingUtil.ensureSelectionExists((JList)this.getList());
    }

    public void updateItem(T item) {
        this.myForm.updateItem(item);
    }

    public void actionsBuilt() {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        this.myForm.createToolbar();
    }

    private static class Form<T> {
        private JComponent myWholePanel;
        private JPanel myActionsPlace;
        private JList myList;
        private final ReorderableListToolbar<T> myListController;

        public Form() {
            this.$$$setupUI$$$();
            this.myList.setModel(new DefaultListModel());
            if (ApplicationManager.getApplication() == null) {
                this.myListController = new ReorderableListToolbar(this.myList);
                return;
            }
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
            this.myListController = new ReorderableListToolbar(this.myList);
        }

        public void createToolbar() {
            this.myActionsPlace.removeAll();
            this.myActionsPlace.setLayout(new BorderLayout());
            this.myActionsPlace.add((Component)this.myListController.createActionToolbar(true).getComponent(), "Center");
        }

        public ReorderableListController<T> getListActionsBuilder() {
            return this.myListController;
        }

        private DefaultListModel getListModel() {
            return (DefaultListModel)this.myList.getModel();
        }

        public void select(T item) {
            ListScrollingUtil.selectItem((JList)this.myList, item);
        }

        public void updateItem(T item) {
            DefaultListModel model = this.getListModel();
            model.setElementAt(item, model.indexOf(item));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JList jList;
            JPanel jPanel;
            JPanel jPanel2 = new JPanel();
            this.myWholePanel = jPanel2;
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myActionsPlace = jPanel = new JPanel();
            jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel2.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            this.myList = jList = new JList();
            jList.setSelectionMode(0);
            jScrollPane.setViewportView(jList);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }
}

