/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class SerializableClassInSecureContextInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.class.in.secure.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/SerializableClassInSecureContextInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serializable.class.in.secure.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/SerializableClassInSecureContextInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableClassInSecureContextVisitor();
    }

    private static class SerializableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private SerializableClassInSecureContextVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/security/SerializableClassInSecureContextInspection$SerializableClassInSecureContextVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!SerializationUtils.isWriteObject(method) || !ControlFlowUtils.methodAlwaysThrowsException(method)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

