/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import org.jetbrains.annotations.NotNull;

public class RecursionVisitor
extends JavaRecursiveElementVisitor {
    private boolean recursive;
    private final PsiMethod method;
    private final String methodName;

    public RecursionVisitor(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/RecursionVisitor.<init> must not be null");
        }
        this.recursive = false;
        this.method = method;
        this.methodName = method.getName();
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/RecursionVisitor.visitElement must not be null");
        }
        if (!this.recursive) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/RecursionVisitor.visitMethodCallExpression must not be null");
        }
        if (this.recursive) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String calledMethodName = methodExpression.getReferenceName();
        if (calledMethodName == null) {
            return;
        }
        if (!calledMethodName.equals(this.methodName)) {
            return;
        }
        PsiMethod calledMethod = call.resolveMethod();
        if (!this.method.equals(calledMethod)) {
            return;
        }
        if (this.method.hasModifierProperty("static") || this.method.hasModifierProperty("private")) {
            this.recursive = true;
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            this.recursive = true;
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

