/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ExceptionNameDoesntEndWithExceptionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ExceptionClassNameDoesntEndWithException" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ExceptionNameDoesntEndWithExceptionInspection.getID must not return null");
        }
        return "ExceptionClassNameDoesntEndWithException";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("exception.name.doesnt.end.with.exception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ExceptionNameDoesntEndWithExceptionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("exception.name.doesnt.end.with.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ExceptionNameDoesntEndWithExceptionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExceptionNameDoesntEndWithExceptionVisitor();
    }

    private static class ExceptionNameDoesntEndWithExceptionVisitor
    extends BaseInspectionVisitor {
        private ExceptionNameDoesntEndWithExceptionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/ExceptionNameDoesntEndWithExceptionInspection$ExceptionNameDoesntEndWithExceptionVisitor.visitClass must not be null");
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String exception = "Exception";
            if (className.endsWith("Exception")) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "java.lang.Exception")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

