/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MoveClassFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class TestCaseInProductCodeInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.case.in.product.code.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseInProductCodeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("JUnitTestCaseInProductSource" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseInProductCodeInspection.getID must not return null");
        }
        return "JUnitTestCaseInProductSource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.case.in.product.code.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseInProductCodeInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveClassFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseInProductCodeVisitor();
    }

    private static class TestCaseInProductCodeVisitor
    extends BaseInspectionVisitor {
        private TestCaseInProductCodeVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/TestCaseInProductCodeInspection$TestCaseInProductCodeVisitor.visitClass must not be null");
            }
            if (TestUtils.isTest(aClass)) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "junit.framework.TestCase")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

