/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk15;

import com.intellij.lang.StdLanguages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawUseOfParameterizedTypeInspection
extends BaseInspection {
    public boolean ignoreObjectConstruction = true;
    public boolean ignoreTypeCasts = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("raw.use.of.parameterized.type.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/RawUseOfParameterizedTypeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("raw.use.of.parameterized.type.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/RawUseOfParameterizedTypeInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.new.objects.option", new Object[0]), "ignoreObjectConstruction");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.type.casts.option", new Object[0]), "ignoreTypeCasts");
        return optionsPanel;
    }

    public String getAlternativeID() {
        return "unchecked";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RawUseOfParameterizedTypeVisitor();
    }

    private class RawUseOfParameterizedTypeVisitor
    extends BaseInspectionVisitor {
        private RawUseOfParameterizedTypeVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/RawUseOfParameterizedTypeInspection$RawUseOfParameterizedTypeVisitor.visitNewExpression must not be null");
            }
            if (!this.hasNeededLanguageLevel((PsiElement)expression)) {
                return;
            }
            super.visitNewExpression(expression);
            if (RawUseOfParameterizedTypeInspection.this.ignoreObjectConstruction) {
                return;
            }
            if (expression.getArrayInitializer() != null || expression.getArrayDimensions().length > 0) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            this.checkReferenceElement(classReference);
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            if (typeElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/RawUseOfParameterizedTypeInspection$RawUseOfParameterizedTypeVisitor.visitTypeElement must not be null");
            }
            if (!this.hasNeededLanguageLevel((PsiElement)typeElement)) {
                return;
            }
            super.visitTypeElement(typeElement);
            PsiElement parent = typeElement.getParent();
            if (parent instanceof PsiInstanceOfExpression || parent instanceof PsiClassObjectAccessExpression) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreTypeCasts && parent instanceof PsiTypeCastExpression) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiComment.class) != null) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            this.checkReferenceElement(referenceElement);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (!this.hasNeededLanguageLevel((PsiElement)reference)) {
                return;
            }
            super.visitReferenceElement(reference);
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)referenceParent;
            PsiElement listParent = referenceList.getParent();
            if (!(listParent instanceof PsiClass)) {
                return;
            }
            this.checkReferenceElement(reference);
        }

        private void checkReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                return;
            }
            PsiType[] typeParameters = reference.getTypeParameters();
            if (typeParameters.length > 0) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            PsiElement qualifier = reference.getQualifier();
            if (qualifier instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement qualifierReference = (PsiJavaCodeReferenceElement)qualifier;
                if (!(aClass.hasModifierProperty("static") || aClass.isInterface() || aClass.isEnum())) {
                    this.checkReferenceElement(qualifierReference);
                }
            }
            if (!aClass.hasTypeParameters()) {
                return;
            }
            this.registerError((PsiElement)reference, new Object[0]);
        }

        private boolean hasNeededLanguageLevel(PsiElement element) {
            if (element.getLanguage() != StdLanguages.JAVA) {
                return false;
            }
            return PsiUtil.isLanguageLevel5OrHigher((PsiElement)element);
        }
    }
}

