/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.errorhandling.CatchParameterUsedVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedCatchParameterInspection
extends BaseInspection {
    public boolean m_ignoreCatchBlocksWithComments = false;
    public boolean m_ignoreTestCases = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unused.catch.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/UnusedCatchParameterInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unused.catch.parameter.ignore.catch.option", new Object[0]), "m_ignoreCatchBlocksWithComments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unused.catch.parameter.ignore.empty.option", new Object[0]), "m_ignoreTestCases");
        return optionsPanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        boolean namedIgnoreButUsed = (Boolean)infos[0];
        if (namedIgnoreButUsed) {
            string = InspectionGadgetsBundle.message("used.catch.parameter.named.ignore.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/UnusedCatchParameterInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("unused.catch.parameter.problem.descriptor", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/UnusedCatchParameterInspection.buildErrorString must not return null");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean namedIgnoreButUsed = (Boolean)infos[0];
        if (namedIgnoreButUsed) {
            return null;
        }
        return new UnusedCatchParameterFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedCatchParameterVisitor();
    }

    private class UnusedCatchParameterVisitor
    extends BaseInspectionVisitor {
        private UnusedCatchParameterVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/UnusedCatchParameterInspection$UnusedCatchParameterVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            if (UnusedCatchParameterInspection.this.m_ignoreTestCases && TestUtils.isPartOfJUnitTestMethod((PsiElement)statement)) {
                return;
            }
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                this.checkCatchSection(catchSection);
            }
        }

        private void checkCatchSection(PsiCatchSection section) {
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            String parametername = parameter.getName();
            boolean namedIgnore = "ignore".equals(parametername) || "ignored".equals(parametername);
            PsiCodeBlock block = section.getCatchBlock();
            if (block == null) {
                return;
            }
            if (UnusedCatchParameterInspection.this.m_ignoreCatchBlocksWithComments) {
                PsiElement[] children;
                for (PsiElement child : children = block.getChildren()) {
                    if (!(child instanceof PsiComment)) continue;
                    return;
                }
            }
            CatchParameterUsedVisitor visitor = new CatchParameterUsedVisitor(parameter);
            block.accept((PsiElementVisitor)visitor);
            if (visitor.isUsed()) {
                if (namedIgnore) {
                    this.registerVariableError((PsiVariable)parameter, true);
                }
                return;
            }
            if (namedIgnore) {
                return;
            }
            this.registerVariableError((PsiVariable)parameter, false);
        }
    }

    private static class UnusedCatchParameterFix
    extends InspectionGadgetsFix {
        private UnusedCatchParameterFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/UnusedCatchParameterInspection$UnusedCatchParameterFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiIdentifier)) {
                return;
            }
            PsiIdentifier identifier = (PsiIdentifier)element;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiIdentifier newIdentifier = factory.createIdentifier("ignored");
            identifier.replace((PsiElement)newIdentifier);
        }
    }
}

