/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EncapsulateVariableFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicFieldInspection
extends BaseInspection {
    public boolean ignoreEnums = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/PublicFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/PublicFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("public.field.ignore.enum.type.fields.option", new Object[0]), (InspectionProfileEntry)this, "ignoreEnums");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EncapsulateVariableFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldVisitor();
    }

    private class PublicFieldVisitor
    extends BaseInspectionVisitor {
        private PublicFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/encapsulation/PublicFieldInspection$PublicFieldVisitor.visitField must not be null");
            }
            if (!field.hasModifierProperty("public")) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                PsiClassType classType;
                PsiClass aClass;
                if (field.hasModifierProperty("static")) {
                    return;
                }
                PsiType type = field.getType();
                if (ClassUtils.isImmutable(type)) {
                    return;
                }
                if (PublicFieldInspection.this.ignoreEnums && type instanceof PsiClassType && (aClass = (classType = (PsiClassType)type).resolve()) != null && aClass.isEnum()) {
                    return;
                }
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

