/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionGadgetsFix
implements LocalQuickFix {
    public static final InspectionGadgetsFix[] EMPTY_ARRAY = new InspectionGadgetsFix[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.siyeh.ig.InspectionGadgetsFix");
    private boolean myOnTheFly = false;

    @NotNull
    public String getFamilyName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/InspectionGadgetsFix.getFamilyName must not return null");
        }
        return "";
    }

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.applyFix must not be null");
        }
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement == null || !problemElement.isValid()) {
            return;
        }
        if (InspectionGadgetsFix.isQuickFixOnReadOnlyFile(problemElement)) {
            return;
        }
        try {
            this.doFix(project, descriptor);
        }
        catch (IncorrectOperationException e) {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            Logger logger = Logger.getInstance((String)className);
            logger.error((Throwable)e);
        }
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2) throws IncorrectOperationException;

    protected static void deleteElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.deleteElement must not be null");
        }
        element.delete();
    }

    protected static void replaceExpression(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) throws IncorrectOperationException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceExpression must not be null");
        }
        if (newExpressionText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceExpression must not be null");
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
        PsiElement replacementExpression = expression.replace((PsiElement)newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        styleManager.reformat(replacementExpression);
    }

    protected static void replaceExpressionWithReferenceTo(@NotNull PsiExpression expression, @NotNull PsiMember target) throws IncorrectOperationException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceExpressionWithReferenceTo must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceExpressionWithReferenceTo must not be null");
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiReferenceExpression newExpression = (PsiReferenceExpression)factory.createExpressionFromText("xxx", (PsiElement)expression);
        PsiReferenceExpression replacementExpression = (PsiReferenceExpression)expression.replace((PsiElement)newExpression);
        PsiElement element = replacementExpression.bindToElement((PsiElement)target);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        styleManager.shortenClassReferences(element);
    }

    protected static void replaceExpressionAndShorten(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) throws IncorrectOperationException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceExpressionAndShorten must not be null");
        }
        if (newExpressionText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceExpressionAndShorten must not be null");
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
        PsiElement replacementExp = expression.replace((PsiElement)newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        styleManager.reformat(replacementExp);
    }

    protected static void replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceStatement must not be null");
        }
        if (newStatementText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceStatement must not be null");
        }
        Project project = statement.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
        PsiElement replacementExp = statement.replace((PsiElement)newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        styleManager.reformat(replacementExp);
    }

    protected static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceStatementAndShortenClassNames must not be null");
        }
        if (newStatementText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.replaceStatementAndShortenClassNames must not be null");
        }
        Project project = statement.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (JspPsiUtil.isInJspFile((PsiElement)statement)) {
            JspFile file;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument((PsiFile)(file = JspPsiUtil.getJspFile((PsiElement)statement)));
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            TextRange textRange = statement.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newStatementText);
            documentManager.commitDocument(document);
            JspxFileViewProvider viewProvider = file.getViewProvider();
            PsiElement elementAt = viewProvider.findElementAt(textRange.getStartOffset(), StdLanguages.JAVA);
            if (elementAt == null) {
                return;
            }
            int endOffset = textRange.getStartOffset() + newStatementText.length();
            while (elementAt.getTextRange().getEndOffset() < endOffset || !(elementAt instanceof PsiStatement)) {
                if ((elementAt = elementAt.getParent()) != null) continue;
                LOG.error("Cannot decode statement");
                return;
            }
            PsiStatement newStatement = (PsiStatement)elementAt;
            javaStyleManager.shortenClassReferences((PsiElement)newStatement);
            TextRange newTextRange = newStatement.getTextRange();
            Language baseLanguage = viewProvider.getBaseLanguage();
            PsiFile element = viewProvider.getPsi(baseLanguage);
            if (element != null) {
                styleManager.reformatRange((PsiElement)element, newTextRange.getStartOffset(), newTextRange.getEndOffset());
            }
        } else {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
            newStatement = (PsiStatement)statement.replace((PsiElement)newStatement);
            javaStyleManager.shortenClassReferences((PsiElement)newStatement);
            styleManager.reformat((PsiElement)newStatement);
        }
    }

    protected static boolean isQuickFixOnReadOnlyFile(PsiElement problemElement) {
        PsiFile containingPsiFile = problemElement.getContainingFile();
        if (containingPsiFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingPsiFile.getVirtualFile();
        Project project = problemElement.getProject();
        ReadonlyStatusHandler handler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus status = handler.ensureFilesWritable(new VirtualFile[]{virtualFile});
        return status.hasReadonlyFiles();
    }

    protected static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.getElementText must not be null");
        }
        StringBuilder out = new StringBuilder();
        InspectionGadgetsFix.getElementText(element, elementToReplace, replacement, out);
        return out.toString();
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.getElementText must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/siyeh/ig/InspectionGadgetsFix.getElementText must not be null");
        }
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children) {
            InspectionGadgetsFix.getElementText(child, elementToReplace, replacement, out);
        }
    }

    public final void setOnTheFly(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    public final boolean isOnTheFly() {
        return this.myOnTheFly;
    }
}

