/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertIntegerToDecimalPredicate;
import com.siyeh.ipp.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConvertIntegerToDecimalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToDecimalPredicate convertIntegerToDecimalPredicate = new ConvertIntegerToDecimalPredicate();
        if (convertIntegerToDecimalPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/integer/ConvertIntegerToDecimalIntention.getElementPredicate must not return null");
        }
        return convertIntegerToDecimalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String decimalString;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/integer/ConvertIntegerToDecimalIntention.processIntention must not be null");
        }
        PsiExpression expression = (PsiExpression)element;
        boolean negated = ExpressionUtils.isNegated(expression);
        Number value = (Number)ExpressionUtils.computeConstantExpression(expression);
        if (value == null) {
            return;
        }
        PsiType type = expression.getType();
        if (PsiType.INT.equals(type)) {
            decimalString = negated ? String.valueOf(-value.intValue()) : String.valueOf(value.intValue());
        } else if (PsiType.LONG.equals(type)) {
            decimalString = negated ? String.valueOf(-value.longValue()) + 'L' : String.valueOf(value.longValue()) + 'L';
        } else if (PsiType.FLOAT.equals(type)) {
            decimalString = negated ? String.valueOf(-value.floatValue()) + 'f' : String.valueOf(value.floatValue()) + 'f';
        } else if (PsiType.DOUBLE.equals(type)) {
            decimalString = negated ? String.valueOf(-value.doubleValue()) : String.valueOf(value.doubleValue());
        } else {
            return;
        }
        if (negated) {
            ConvertIntegerToDecimalIntention.replaceExpression(decimalString, (PsiExpression)expression.getParent());
        } else {
            ConvertIntegerToDecimalIntention.replaceExpression(decimalString, expression);
        }
    }
}

