/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.initialization;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.initialization.SplitDeclarationAndInitializationPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class SplitDeclarationAndInitializationIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        SplitDeclarationAndInitializationPredicate splitDeclarationAndInitializationPredicate = new SplitDeclarationAndInitializationPredicate();
        if (splitDeclarationAndInitializationPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/initialization/SplitDeclarationAndInitializationIntention.getElementPredicate must not return null");
        }
        return splitDeclarationAndInitializationPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiModifierList modifierList;
        PsiType type;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/initialization/SplitDeclarationAndInitializationIntention.processIntention must not be null");
        }
        PsiField field = (PsiField)element.getParent();
        field.normalizeDeclaration();
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return;
        }
        String initializerText = initializer instanceof PsiArrayInitializerExpression ? ((type = initializer.getType()) == null ? initializer.getText() : "new " + type.getCanonicalText() + initializer.getText()) : initializer.getText();
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return;
        }
        boolean fieldIsStatic = field.hasModifierProperty("static");
        PsiClassInitializer[] classInitializers = containingClass.getInitializers();
        PsiClassInitializer classInitializer = null;
        int fieldOffset = field.getTextOffset();
        for (PsiClassInitializer existingClassInitializer : classInitializers) {
            boolean initializerIsStatic;
            int initializerOffset = existingClassInitializer.getTextOffset();
            if (initializerOffset <= fieldOffset || (initializerIsStatic = existingClassInitializer.hasModifierProperty("static")) != fieldIsStatic) continue;
            classInitializer = existingClassInitializer;
            break;
        }
        PsiManager manager = field.getManager();
        Project project = manager.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (classInitializer == null) {
            classInitializer = elementFactory.createClassInitializer();
            classInitializer = (PsiClassInitializer)containingClass.addAfter((PsiElement)classInitializer, (PsiElement)field);
        }
        PsiCodeBlock body = classInitializer.getBody();
        String initializationStatementText = field.getName() + " = " + initializerText + ';';
        PsiExpressionStatement statement = (PsiExpressionStatement)elementFactory.createStatementFromText(initializationStatementText, (PsiElement)body);
        PsiElement addedElement = body.add((PsiElement)statement);
        if (fieldIsStatic && (modifierList = classInitializer.getModifierList()) != null) {
            modifierList.setModifierProperty("static", true);
        }
        initializer.delete();
        CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
        codeStyleManager.reformat((PsiElement)field);
        codeStyleManager.reformat((PsiElement)classInitializer);
        HighlightUtil.highlightElements(Collections.singleton(addedElement));
    }
}

