/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import java.util.HashSet;
import java.util.Set;

class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Set<PsiType> getExceptionTypesHandled(PsiTryStatement statement) {
        PsiParameter[] params;
        HashSet<PsiType> out = new HashSet<PsiType>(10);
        for (PsiParameter param : params = statement.getCatchBlockParameters()) {
            PsiType type = param.getType();
            out.add(type);
        }
        return out;
    }

    private static void calculateExceptionsThrownForStatement(PsiStatement statement, Set<PsiType> exceptionTypes) {
        if (statement == null) {
            return;
        }
        if (!(statement instanceof PsiBreakStatement) && !(statement instanceof PsiContinueStatement)) {
            if (statement instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (returnValue != null) {
                    ExceptionUtils.calculateExceptionsThrown(returnValue, exceptionTypes);
                }
            } else if (statement instanceof PsiThrowStatement) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForThrowStatement(throwStatement, exceptionTypes);
            } else if (statement instanceof PsiExpressionListStatement) {
                PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForExpressionListStatement(expressionListStatement, exceptionTypes);
            } else if (statement instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
                PsiExpression expression = expressionStatement.getExpression();
                ExceptionUtils.calculateExceptionsThrown(expression, exceptionTypes);
            } else if (statement instanceof PsiAssertStatement) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForAssertStatement(assertStatement, exceptionTypes);
            } else if (statement instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForDeclarationStatemt(declarationStatement, exceptionTypes);
            } else if (statement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForForExpression(forStatement, exceptionTypes);
            } else if (statement instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForWhileStatement(whileStatement, exceptionTypes);
            } else if (statement instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForDoWhileStatement(doWhileStatement, exceptionTypes);
            } else if (statement instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForSynchronizedStatement(synchronizedStatement, exceptionTypes);
            } else if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForBlockStatement(block, exceptionTypes);
            } else if (statement instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForLabeledStatement(labeledStatement, exceptionTypes);
            } else if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForIfStatement(ifStatement, exceptionTypes);
            } else if (statement instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForTryStatement(tryStatement, exceptionTypes);
            } else if (statement instanceof PsiSwitchStatement) {
                PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForSwitchStatement(switchStatement, exceptionTypes);
            }
        }
    }

    private static void calculateExceptionsThrownForLabeledStatement(PsiLabeledStatement labeledStatement, Set<PsiType> exceptionTypes) {
        PsiStatement statement = labeledStatement.getStatement();
        ExceptionUtils.calculateExceptionsThrownForStatement(statement, exceptionTypes);
    }

    private static void calculateExceptionsThrownForExpressionListStatement(PsiExpressionListStatement listStatement, Set<PsiType> exceptionTypes) {
        PsiExpression[] expressions;
        PsiExpressionList expressionList = listStatement.getExpressionList();
        for (PsiExpression expression : expressions = expressionList.getExpressions()) {
            ExceptionUtils.calculateExceptionsThrown(expression, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForDeclarationStatemt(PsiDeclarationStatement declarationStatement, Set<PsiType> exceptionTypes) {
        PsiElement[] elements;
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable var;
            PsiExpression initializer;
            if (!(element instanceof PsiVariable) || (initializer = (var = (PsiVariable)element).getInitializer()) == null) continue;
            ExceptionUtils.calculateExceptionsThrown(initializer, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForAssertStatement(PsiAssertStatement assertStatement, Set<PsiType> exceptionTypes) {
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        ExceptionUtils.calculateExceptionsThrown(assertCondition, exceptionTypes);
        PsiExpression assertDescription = assertStatement.getAssertDescription();
        ExceptionUtils.calculateExceptionsThrown(assertDescription, exceptionTypes);
    }

    private static void calculateExceptionsThrownForThrowStatement(PsiThrowStatement throwStatement, Set<PsiType> exceptionTypes) {
        PsiExpression exception = throwStatement.getException();
        if (exception == null) {
            return;
        }
        PsiType type = exception.getType();
        if (type != null) {
            exceptionTypes.add(type);
        }
        ExceptionUtils.calculateExceptionsThrown(exception, exceptionTypes);
    }

    private static void calculateExceptionsThrownForSwitchStatement(PsiSwitchStatement switchStatement, Set<PsiType> exceptionTypes) {
        PsiExpression switchExpression = switchStatement.getExpression();
        ExceptionUtils.calculateExceptionsThrown(switchExpression, exceptionTypes);
        PsiCodeBlock body = switchStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForTryStatement(PsiTryStatement tryStatement, Set<PsiType> exceptionTypes) {
        PsiCodeBlock[] catchBlocks;
        HashSet<PsiType> exceptionThrown = new HashSet<PsiType>(10);
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(tryBlock, exceptionThrown);
        Set<PsiType> exceptionHandled = ExceptionUtils.getExceptionTypesHandled(tryStatement);
        for (PsiType thrownType : exceptionThrown) {
            boolean found = false;
            for (PsiType handledType : exceptionHandled) {
                if (!handledType.isAssignableFrom(thrownType)) continue;
                found = true;
                break;
            }
            if (found) continue;
            exceptionTypes.add(thrownType);
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            ExceptionUtils.calculateExceptionsThrownForCodeBlock(finallyBlock, exceptionTypes);
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            ExceptionUtils.calculateExceptionsThrownForCodeBlock(catchBlock, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForIfStatement(PsiIfStatement ifStatement, Set<PsiType> exceptionTypes) {
        PsiExpression condition = ifStatement.getCondition();
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        ExceptionUtils.calculateExceptionsThrown(condition, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrownForStatement(thenBranch, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrownForStatement(elseBranch, exceptionTypes);
    }

    private static void calculateExceptionsThrownForBlockStatement(PsiBlockStatement block, Set<PsiType> exceptionTypes) {
        PsiCodeBlock codeBlock = block.getCodeBlock();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(codeBlock, exceptionTypes);
    }

    private static void calculateExceptionsThrownForSynchronizedStatement(PsiSynchronizedStatement synchronizedStatement, Set<PsiType> exceptionTypes) {
        PsiExpression lockExpression = synchronizedStatement.getLockExpression();
        if (lockExpression != null) {
            ExceptionUtils.calculateExceptionsThrown(lockExpression, exceptionTypes);
        }
        PsiCodeBlock body = synchronizedStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForDoWhileStatement(PsiDoWhileStatement loopStatement, Set<PsiType> exceptionTypes) {
        PsiExpression condition = loopStatement.getCondition();
        ExceptionUtils.calculateExceptionsThrown(condition, exceptionTypes);
        PsiStatement body = loopStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForStatement(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForWhileStatement(PsiWhileStatement loopStatement, Set<PsiType> exceptionTypes) {
        PsiExpression condition = loopStatement.getCondition();
        ExceptionUtils.calculateExceptionsThrown(condition, exceptionTypes);
        PsiStatement body = loopStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForStatement(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForForExpression(PsiForStatement loopStatement, Set<PsiType> exceptionTypes) {
        PsiStatement initialization = loopStatement.getInitialization();
        PsiExpression condition = loopStatement.getCondition();
        PsiStatement update = loopStatement.getUpdate();
        PsiStatement body = loopStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForStatement(initialization, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrown(condition, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrownForStatement(update, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrownForStatement(body, exceptionTypes);
    }

    private static void calculateExceptionsThrown(PsiExpression expression, Set<PsiType> exceptionTypes) {
        if (expression == null) {
            return;
        }
        if (!(expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression)) {
            if (expression instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForTypeCast(typeCastExpression, exceptionTypes);
            } else if (expression instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForInstanceOf(instanceOfExpression, exceptionTypes);
            } else if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                if (qualifier != null) {
                    ExceptionUtils.calculateExceptionsThrown(qualifier, exceptionTypes);
                }
            } else if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForMethodCall(methodCallExpression, exceptionTypes);
            } else if (expression instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForNewExpression(newExpression, exceptionTypes);
            } else if (expression instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForArrayInitializerExpression(arrayInitializerExpression, exceptionTypes);
            } else if (expression instanceof PsiArrayAccessExpression) {
                PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForArrayAccessExpression(arrayAccessExpression, exceptionTypes);
            } else if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForPrefixException(prefixExpression, exceptionTypes);
            } else if (expression instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForPostixExpression(postfixExpression, exceptionTypes);
            } else if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForBinaryExpression(binaryExpression, exceptionTypes);
            } else if (expression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForAssignmentExpression(assignmentExpression, exceptionTypes);
            } else if (expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForConditionalExcpression(conditionalExpression, exceptionTypes);
            }
        }
    }

    private static void calculateExceptionsThrownForTypeCast(PsiTypeCastExpression typeCastExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = typeCastExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrown(operand, exceptionTypes);
    }

    private static void calculateExceptionsThrownForInstanceOf(PsiInstanceOfExpression instanceOfExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = instanceOfExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrown(operand, exceptionTypes);
    }

    private static void calculateExceptionsThrownForNewExpression(PsiNewExpression newExpression, Set<PsiType> exceptionTypes) {
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] args;
            for (PsiExpression arg : args = argumentList.getExpressions()) {
                ExceptionUtils.calculateExceptionsThrown(arg, exceptionTypes);
            }
        }
        PsiExpression[] arrayDims = newExpression.getArrayDimensions();
        for (PsiExpression arrayDim : arrayDims) {
            ExceptionUtils.calculateExceptionsThrown(arrayDim, exceptionTypes);
        }
        PsiExpression qualifier = newExpression.getQualifier();
        ExceptionUtils.calculateExceptionsThrown(qualifier, exceptionTypes);
        PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
        ExceptionUtils.calculateExceptionsThrown((PsiExpression)arrayInitializer, exceptionTypes);
        PsiMethod method = newExpression.resolveMethod();
        if (method != null) {
            PsiJavaCodeReferenceElement[] list;
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement referenceElement : list = throwsList.getReferenceElements()) {
                PsiClass exceptionClass = (PsiClass)referenceElement.resolve();
                if (exceptionClass == null) continue;
                PsiManager psiManager = exceptionClass.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
                PsiClassType exceptionType = factory.createType(exceptionClass);
                exceptionTypes.add((PsiType)exceptionType);
            }
        }
    }

    private static void calculateExceptionsThrownForMethodCall(PsiMethodCallExpression methodCallExpression, Set<PsiType> exceptionTypes) {
        PsiExpression[] expressions;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression expression : expressions = argumentList.getExpressions()) {
            ExceptionUtils.calculateExceptionsThrown(expression, exceptionTypes);
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        ExceptionUtils.calculateExceptionsThrown((PsiExpression)methodExpression, exceptionTypes);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null) {
            PsiJavaCodeReferenceElement[] list;
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement referenceElement : list = throwsList.getReferenceElements()) {
                PsiClass exceptionClass = (PsiClass)referenceElement.resolve();
                if (exceptionClass == null) continue;
                PsiManager psiManager = exceptionClass.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
                PsiClassType exceptionType = factory.createType(exceptionClass);
                exceptionTypes.add((PsiType)exceptionType);
            }
        }
    }

    private static void calculateExceptionsThrownForConditionalExcpression(PsiConditionalExpression conditionalExpression, Set<PsiType> exceptionTypes) {
        PsiExpression condition = conditionalExpression.getCondition();
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        ExceptionUtils.calculateExceptionsThrown(condition, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrown(elseExpression, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrown(thenExpression, exceptionTypes);
    }

    private static void calculateExceptionsThrownForBinaryExpression(PsiBinaryExpression binaryExpression, Set<PsiType> exceptionTypes) {
        PsiExpression lOperand = binaryExpression.getLOperand();
        ExceptionUtils.calculateExceptionsThrown(lOperand, exceptionTypes);
        PsiExpression rhs = binaryExpression.getROperand();
        ExceptionUtils.calculateExceptionsThrown(rhs, exceptionTypes);
    }

    private static void calculateExceptionsThrownForAssignmentExpression(PsiAssignmentExpression assignmentExpression, Set<PsiType> exceptionTypes) {
        PsiExpression lOperand = assignmentExpression.getLExpression();
        ExceptionUtils.calculateExceptionsThrown(lOperand, exceptionTypes);
        PsiExpression rhs = assignmentExpression.getRExpression();
        ExceptionUtils.calculateExceptionsThrown(rhs, exceptionTypes);
    }

    private static void calculateExceptionsThrownForArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializerExpression, Set<PsiType> exceptionTypes) {
        PsiExpression[] initializers;
        for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
            ExceptionUtils.calculateExceptionsThrown(initializer, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForArrayAccessExpression(PsiArrayAccessExpression arrayAccessExpression, Set<PsiType> exceptionTypes) {
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        ExceptionUtils.calculateExceptionsThrown(arrayExpression, exceptionTypes);
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        ExceptionUtils.calculateExceptionsThrown(indexExpression, exceptionTypes);
    }

    private static void calculateExceptionsThrownForPrefixException(PsiPrefixExpression prefixExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = prefixExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrown(operand, exceptionTypes);
    }

    private static void calculateExceptionsThrownForPostixExpression(PsiPostfixExpression postfixExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = postfixExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrown(operand, exceptionTypes);
    }

    public static void calculateExceptionsThrownForCodeBlock(PsiCodeBlock codeBlock, Set<PsiType> exceptionTypes) {
        PsiStatement[] statements;
        if (codeBlock == null) {
            return;
        }
        for (PsiStatement statement : statements = codeBlock.getStatements()) {
            ExceptionUtils.calculateExceptionsThrownForStatement(statement, exceptionTypes);
        }
    }
}

