/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.chartostring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.chartostring.CharToStringPredicate;
import org.jetbrains.annotations.NotNull;

public class CharToStringIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CharToStringPredicate charToStringPredicate = new CharToStringPredicate();
        if (charToStringPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/chartostring/CharToStringIntention.getElementPredicate must not return null");
        }
        return charToStringPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/chartostring/CharToStringIntention.processIntention must not be null");
        }
        PsiLiteralExpression charLiteral = (PsiLiteralExpression)element;
        String charLiteralText = charLiteral.getText();
        String stringLiteral = CharToStringIntention.stringForCharLiteral(charLiteralText);
        CharToStringIntention.replaceExpression(stringLiteral, (PsiExpression)charLiteral);
    }

    private static String stringForCharLiteral(String charLiteral) {
        if ("'\"'".equals(charLiteral)) {
            return "\"\\\"\"";
        }
        return '\"' + charLiteral.substring(1, charLiteral.length() - 1) + '\"';
    }
}

