/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.importToCvs;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ImportConfiguration;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.cvsSupport2.ui.experts.importToCvs.FileExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxTableCellEditor;
import com.intellij.util.ui.ComboBoxTableCellRenderer;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CustomizeKeywordSubstitutionStep
extends WizardStep {
    private static final ColumnInfo KEYWORD_SUBSTITUTION = new ColumnInfo(CvsBundle.message((String)"import.wizard.keyword.substitution.column.name", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((FileExtension)object).getKeywordSubstitutionsWithSelection();
        }

        public Comparator getComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    KeywordSubstitutionWrapper firstSubstitution = (KeywordSubstitutionWrapper)((FileExtension)o1).getKeywordSubstitutionsWithSelection().getSelection();
                    KeywordSubstitutionWrapper secondSubstitution = (KeywordSubstitutionWrapper)((FileExtension)o2).getKeywordSubstitutionsWithSelection().getSelection();
                    return firstSubstitution.toString().compareTo(secondSubstitution.toString());
                }
            };
        }

        public boolean isCellEditable(Object o) {
            return true;
        }

        public void setValue(Object o, Object aValue) {
            ((FileExtension)o).setKeywordSubstitution((KeywordSubstitutionWrapper)aValue);
        }

        public TableCellRenderer getRenderer(Object o) {
            return ComboBoxTableCellRenderer.INSTANCE;
        }

        public TableCellEditor getEditor(Object item) {
            return ComboBoxTableCellEditor.INSTANCE;
        }
    };
    private static final ColumnInfo EXTENSION_COLUMN = new ColumnInfo(CvsBundle.message((String)"import.wizard.file.extension.column.name", (Object[])new Object[0])){

        public Object valueOf(Object o) {
            return ((FileExtension)o).getExtension();
        }

        public Comparator getComparator() {
            return new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((FileExtension)o).getExtension().compareTo(((FileExtension)o1).getExtension());
                }
            };
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{EXTENSION_COLUMN, KEYWORD_SUBSTITUTION};
    private final TableView myTable;
    private final ListTableModel<FileExtension> myModel = new ListTableModel(COLUMNS);
    private final ImportConfiguration myImportConfiguration;

    public CustomizeKeywordSubstitutionStep(String description, CvsWizard wizard, ImportConfiguration importConfiguration) {
        super(description, wizard);
        this.myTable = new TableView(this.myModel);
        this.myTable.setMinRowHeight(new JComboBox<E>().getPreferredSize().height + 2);
        this.myImportConfiguration = importConfiguration;
        this.myModel.setItems(this.collectFileTypes());
        this.init();
    }

    @Override
    protected void dispose() {
    }

    private List<FileExtension> collectFileTypes() {
        FileType[] fileTypes;
        Collection<FileExtension> storedExtensions = this.myImportConfiguration.getExtensions();
        ArrayList<FileExtension> result = new ArrayList<FileExtension>();
        result.addAll(storedExtensions);
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            String[] extensions;
            for (String extension : extensions = FileTypeManager.getInstance().getAssociatedExtensions(fileType)) {
                FileExtension fileExtension = new FileExtension(extension);
                if (result.contains(fileExtension)) continue;
                result.add(fileExtension);
            }
        }
        return result;
    }

    @Override
    public void saveState() {
        this.myImportConfiguration.setExtensions(this.myModel.getItems());
    }

    @Override
    public boolean nextIsEnabled() {
        return true;
    }

    @Override
    public boolean setActive() {
        return true;
    }

    @Override
    protected JComponent createComponent() {
        return ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
    }

    public List<FileExtension> getFileExtensions() {
        return this.myModel.getItems();
    }
}

