/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.quickedit;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.plaf.beg.BegBorders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class QuickEditEditor {
    private final Project myProject;
    private final JComponent myPanel;
    private final QuickEditSaver mySaver;
    private EditorEx myEditor;
    private JBPopup myPopup;
    private Boolean myCancelFlag;

    public QuickEditEditor(Document document, Project project, FileType ft, @NotNull QuickEditSaver saver) {
        if (saver == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/quickedit/QuickEditEditor.<init> must not be null");
        }
        this.myProject = project;
        this.mySaver = saver;
        this.myEditor = (EditorImpl)EditorFactory.getInstance().createEditor(document, project);
        this.myEditor.setHighlighter(HighlighterFactory.createHighlighter((Project)project, (FileType)ft));
        this.myEditor.setEmbeddedIntoDialogWrapper(true);
        EditorSettings settings = this.myEditor.getSettings();
        settings.setFoldingOutlineShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setVirtualSpace(false);
        settings.setAdditionalLinesCount(2);
        this.myPanel = new MyPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public void setCancel(boolean cancel) {
        if (this.myCancelFlag == null) {
            this.myCancelFlag = cancel;
        }
    }

    private String releaseEditor() {
        if (this.myEditor != null) {
            Document document = this.myEditor.getDocument();
            String text = document.getText();
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
            this.myEditor = null;
            return text;
        }
        return "";
    }

    public void install(JBPopup popup) {
        this.myPopup = popup;
        JComponent component = this.myEditor.getContentComponent();
        component.requestFocus();
        new EscAction(this).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(27, 0)), component);
        new SaveAction(this).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 2)), component);
        this.setStatusBarText("Press Ctrl+Enter to save, Escape to cancel.");
    }

    private void setStatusBarText(String text) {
        WindowManager wm = WindowManager.getInstance();
        StatusBar statusBar = wm.getStatusBar(this.myProject);
        statusBar.setInfo(text);
    }

    public void uninstall() {
        this.setStatusBarText("");
        final String text = this.releaseEditor();
        assert (this.myCancelFlag != null);
        if (!this.myCancelFlag.booleanValue()) {
            new WriteCommandAction(this.myProject, new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    QuickEditEditor.this.mySaver.save(text);
                }
            }.execute();
        }
        this.myPopup = null;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private static class SaveAction
    extends AnAction {
        private final QuickEditEditor myEditor;

        public SaveAction(QuickEditEditor editor) {
            super("Save");
            this.myEditor = editor;
        }

        public void actionPerformed(AnActionEvent event) {
            this.myEditor.setCancel(false);
            this.myEditor.myPopup.cancel();
        }
    }

    private static class EscAction
    extends AnAction {
        private final QuickEditEditor myEditor;

        public EscAction(QuickEditEditor editor) {
            super("Esc");
            this.myEditor = editor;
        }

        public void actionPerformed(AnActionEvent event) {
            this.myEditor.setCancel(true);
            this.myEditor.myPopup.cancel();
        }
    }

    public static interface QuickEditSaver {
        public void save(String var1);
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            super(new BorderLayout());
            this.add((Component)QuickEditEditor.this.myEditor.getComponent(), "Center");
            this.setBorder((Border)new BegBorders.FlatLineBorder());
            this.setPreferredSize(new Dimension(400, 100));
        }

        public Object getData(String s) {
            if (LangDataKeys.EDITOR.is(s)) {
                return QuickEditEditor.this.myEditor;
            }
            return null;
        }
    }
}

